# Table structure for table `chans`
DROP TABLE IF EXISTS chans;
CREATE TABLE chans (
  id int(11) NOT NULL auto_increment,
  name varchar(64) NOT NULL default '',
  enctype tinyint(1) NOT NULL default '0',
  pass varchar(64) default NULL,
  url varchar(64) default NULL,
  email varchar(64) default NULL,
  founder int(11) NOT NULL default '0',
  sucessor int(11) NOT NULL default '0',
  last_topic varchar(255) default NULL,
  last_topic_setter varchar(32) default NULL,
  last_topic_time timestamp(14) NOT NULL,
  t_reg timestamp(14) NOT NULL,
  t_ident timestamp(14) NOT NULL,
  mlock varchar(64) default NULL,
  status int(11) NOT NULL default '0',
  memoscount int(2) NOT NULL default '0',
  entrymsg varchar(255) default NULL,
  t_maxusers timestamp(14) NOT NULL,
  maxusers int(4) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY id (id)
) TYPE=MyISAM;

# -------------------------------------------------------- #
# Table structure for table `chans_accesses`
DROP TABLE IF EXISTS chans_accesses;
CREATE TABLE chans_accesses (
  chan_id int(11) NOT NULL default '0',
  who int(11) NOT NULL default '0',
  nick_id int(11) NOT NULL default '0',
  level int(5) NOT NULL default '0',
  KEY chan_id (chan_id,nick_id)
) TYPE=MyISAM COMMENT='Channel access list info';

# -------------------------------------------------------- #
# Table structure for table `chans_akicks`
DROP TABLE IF EXISTS chans_akicks;
CREATE TABLE chans_akicks (
  chan_id int(11) NOT NULL default '0',
  who int(11) NOT NULL default '0',
  t_kick timestamp(14) NOT NULL,  
  mask varchar(64) NOT NULL default '',
  reason varchar(128) default NULL,
  KEY chan_id (chan_id)
) TYPE=MyISAM;

