/*
 *  GNOME IrDA Monitor (girda)
 *  Copyright (C) 2001 Ragnar Henriksen <ragnar@juniks.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib-2.0/glib.h>
#include <glib/gi18n-lib.h>

#include <sys/socket.h>
#include <linux/types.h>
#include <linux/irda.h>
#include <errno.h>

#ifdef ENABLE_OPENOBEX
#  include <openobex/obex.h>
#endif

#include "irda_misc.h"


#ifdef ENABLE_OPENOBEX
void obex_event(obex_t *handle, obex_object_t *object, gint mode, gint event, gint obex_cmd, gint obex_rsp);
#endif

volatile int finished = FALSE;

struct irda_device_list* 
irda_discover_device(int sfd)
{
    	struct irda_device_list *list;
    	struct irda_device_info *dev;
	gchar          *buf;
	gchar          *devices;
	gchar          *sep = ", ";
        gint           s;
	gint           i;

	gint fd;
	gint len;

	if(sfd >= 0)
		fd = sfd;
	else
	{
		fd = socket(AF_IRDA, SOCK_STREAM, 0);
		if ( fd == -1 ) {
			perror("Failed to create IRDA socket");
			return NULL;
		}
	}
	
	len = sizeof(*list) + sizeof(*dev) * 10;
	buf = g_new0(gchar, len);

	list = (struct irda_device_list *)buf;

	dev = list->dev;
	s = len;
	devices = 0;

	if ( getsockopt(fd, SOL_IRLMP, IRLMP_ENUMDEVICES, buf, &s) == 0 ) {
	} else {
		g_free(buf);
		list = NULL;
	}
	
	if(sfd<0)
        close(fd);

    	return list;
}

struct _dev_info *
irda_get_hints( gint *num )
{

    	struct irda_device_list *list;
    	struct irda_device_info *dev;
	struct _dev_info *p;
	struct _dev_info *inf;
	gchar          *buf;
	gchar          *sep = ", ";
    	gint           s;
	gint           i;

	gint fd;
	gint len;

    	fd = socket(AF_IRDA, SOCK_STREAM, 0);
	if ( fd == -1 ) {
		inf = 0;
		*num = -1;
		return inf;
	}
     
	len = sizeof(*list) + sizeof(*dev) * 10;
	buf = g_new0(gchar, len);

	list = (struct irda_device_list *)buf;

	dev = list->dev;
	s = len;
	inf = 0;
	*num = -1;
	if ( getsockopt(fd, SOL_IRLMP, IRLMP_ENUMDEVICES, buf, &s) == 0 ) {
		*num = list->len;
		for (i = 0; i < list->len ; i++) {
			p = (struct _dev_info *)g_malloc(sizeof(struct _dev_info));
			p->name = g_strdup(dev[i].info);
			p->hints[0] = dev[i].hints[0];
			p->hints[1] = dev[i].hints[1];
			p->next = inf;
			inf = p;
		}
	}
	
    	g_free(buf);
    	close(fd);

	return inf;
}

struct _dev_info *
irda_get_hints_fd( gint *num , int fd)
{

    	struct irda_device_list *list;
    	struct irda_device_info *dev;
	struct _dev_info *p;
	struct _dev_info *inf;
	gchar          *buf;
	gchar          *sep = ", ";
    	gint           s;
	gint           i;

	gint len;

	if ( fd == -1 ) {
		inf = 0;
		*num = -1;
		return inf;
	}
     
	len = sizeof(*list) + sizeof(*dev) * 10;
	buf = g_new0(gchar, len);

	list = (struct irda_device_list *)buf;

	dev = list->dev;
	s = len;
	inf = 0;
	if ( getsockopt(fd, SOL_IRLMP, IRLMP_ENUMDEVICES, buf, &s) == 0 ) {
		*num = list->len;
		for (i = 0; i < list->len ; i++) {
			p = (struct _dev_info *)g_malloc(sizeof(struct _dev_info));
			p->name = g_strdup(dev[i].info);
			p->hints[0] = dev[i].hints[0];
			p->hints[1] = dev[i].hints[1];
			p->next = inf;
			inf = p;
		}
	}
	
    	g_free(buf);

	return inf;
}


void free_dev_info(struct _dev_info * devices)
{
	struct _dev_info * p;
	p = devices;
    	while ( p ) {
        	devices = p->next;
		g_free( p->name );
		g_free( p );
        	p = devices;
    	}
}

int irda_check()
{
	int sock;
	sock = socket(AF_IRDA, SOCK_STREAM, 0);
	if(sock>=0) {
		close(sock);
		return 1;
	} else
		return 0;
}
