/*
 *  ircd-hybrid: an advanced Internet Relay Chat Daemon(ircd).
 *  m_away.c: Sets/removes away status on a user.
 *
 *  Copyright (C) 2002 by the past and present ircd coders, and others.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *  USA
 *
 *  $Id: m_away.c 1484 2012-07-26 18:38:56Z michael $
 */

#include "stdinc.h"
#include "client.h"
#include "irc_string.h"
#include "ircd.h"
#include "numeric.h"
#include "send.h"
#include "parse.h"
#include "modules.h"
#include "conf.h"
#include "s_serv.h"
#include "packet.h"
#include "s_user.h"


/*
 * m_away
 *  parv[0] = sender prefix
 *  parv[1] = away message
 */
static void
m_away(struct Client *client_p, struct Client *source_p,
       int parc, char *parv[])
{
  if (!IsFloodDone(source_p))
    flood_endgrace(source_p);

  if (parc < 2 || EmptyString(parv[1]))
  {
    /* Marking as not away */
    if (source_p->away[0])
    {
      /* we now send this only if they were away before --is */
      sendto_server(client_p, CAP_TS6, NOCAPS,
                    ":%s AWAY", ID(source_p));
      sendto_server(client_p, NOCAPS, CAP_TS6,
                    ":%s AWAY", source_p->name);
      source_p->away[0] = '\0';
    }

    sendto_one(source_p, form_str(RPL_UNAWAY),
               me.name, source_p->name);
    return;
  }

  if ((CurrentTime - source_p->localClient->last_away) < ConfigFileEntry.pace_wait)
  {
    sendto_one(source_p, form_str(RPL_LOAD2HI),
               me.name, source_p->name);
    return;
  }

  source_p->localClient->last_away = CurrentTime;
  strlcpy(source_p->away, parv[1], sizeof(source_p->away));

  sendto_server(client_p, CAP_TS6, NOCAPS,
                ":%s AWAY :%s", ID(source_p), source_p->away);
  sendto_server(client_p, NOCAPS, CAP_TS6,
                ":%s AWAY :%s", source_p->name, source_p->away);
  sendto_one(source_p, form_str(RPL_NOWAWAY), me.name, source_p->name);
}

static void
ms_away(struct Client *client_p, struct Client *source_p,
        int parc, char *parv[])
{
  if (!IsClient(source_p))
    return;

  if (parc < 2 || EmptyString(parv[1]))
  {
    /* Marking as not away */
    if (source_p->away[0])
    {
      /* we now send this only if they were away before --is */
      sendto_server(client_p, CAP_TS6, NOCAPS,
                    ":%s AWAY", ID(source_p));
      sendto_server(client_p, NOCAPS, CAP_TS6,
                    ":%s AWAY", source_p->name);
      source_p->away[0] = '\0';
    }

    return;
  }

  strlcpy(source_p->away, parv[1], sizeof(source_p->away));

  sendto_server(client_p, CAP_TS6, NOCAPS,
                ":%s AWAY :%s", ID(source_p), source_p->away);
  sendto_server(client_p, NOCAPS, CAP_TS6,
                ":%s AWAY :%s", source_p->name, source_p->away);
}

static struct Message away_msgtab = {
  "AWAY", 0, 0, 0, MAXPARA, MFLG_SLOW, 0,
  { m_unregistered, m_away, ms_away, m_ignore, m_away, m_ignore }
};

static void
module_init(void)
{
  mod_add_cmd(&away_msgtab);
  add_isupport("AWAYLEN", NULL, AWAYLEN);
}

static void
module_exit(void)
{
  mod_del_cmd(&away_msgtab);
  delete_isupport("AWAYLEN");
}

struct module module_entry = {
  .node    = { NULL, NULL, NULL },
  .name    = NULL,
  .version = "$Revision: 1484 $",
  .handle  = NULL,
  .modinit = module_init,
  .modexit = module_exit,
  .flags   = 0
};
