/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef STATISTICSUTILITY_H
#define STATISTICSUTILITY_H

#include "ipodutility.h"
#include "ipod.h"

/**
 * This class implements the IPodUtility Interface.
 * It displays information about the state of your iPod like the number of
 * tracks and playlists stored on it.
 * @author Michael Schulze
 */
class StatisticsUtility : public IPodUtility
{
public:
    StatisticsUtility(IPod& ipod);
    virtual ~StatisticsUtility();

    virtual const QString& getName();
    virtual const QString& getDefaultMimeType();
    virtual void handleRequest(const KURL& request, QByteArray& response, QString& mimeType);

protected:
    IPod& _ipod_;
    static const QString defaultmimetype;
    static const QString name;
};

#endif
