#!/bin/bash
# iPodder linux installer 2.0
# Created by Scott Grayban <sgrayban@borgnet.us>
# Mon Apr 11 2005
# lets define all our variables first
# this really makes the script easier to change if needed
#########################################################
NAME="iPodder"
INSTALLER_NAME="$NAME installer"
INSTALLER_VERSION="2.0"
INSTALLER_PATH="/opt/${NAME}"
INSTALLER_BIN="/usr/bin"
INSTALLER_COPYRIGHT="Copyright 2005, ${NAME} Team"
INSTALLER_LICENSE="
${NAME} comes with ABSOLUTELY NO WARRANTY. This is free
software, and you are welcome to redistribute it under the terms
of the GNU General Public License.
See LICENSE for details.
"
SUPPORT="http://ipodder.sourceforge.net/support/"
WEBSITE="http://ipodder.sourceforge.net/"

# Clean active window
clear

echo "Welcome to the ${INSTALLER_NAME}"
echo "${INSTALLER_NAME} written by Scott Grayban"
echo "${INSTALLER_NAME} ${INSTALLER_VERSION} (${INSTALLER_COPYRIGHT})"
echo "${INSTALLER_LICENSE}"
echo "---------------"
echo ""

#check if we are root to install
echo $N "Checking UID... "
if [ `id -u` = "0" ]
  then
    echo "GOOD! your root."
    echo ""
  else
    echo "Sorry, you have to be 'root'. Please su(do) and try again"
    echo ""
    exit 1
fi

# lets remove the old historical directory first
if [ -d /opt/iSpider ]
  then
    /bin/rm -fr /opt/iSpider
fi

echo "Starting installation/update"
echo ""
# lets check if ipodder has been installed before
# if so we just delete the contents to make sure they get the newest files
# if not we create it
if [ -d ${INSTALLER_PATH} ]
  then
echo "Install type:   Upgrade"
/bin/rm -fr ${INSTALLER_PATH}/*
  else
echo "Install type:   New"
mkdir ${INSTALLER_PATH}
fi

echo "Install path:   ${INSTALLER_PATH}"
echo "Bin path:       ${INSTALLER_BIN}"
echo -e '\E[1;33;44m\E[5m'"\033[1m***NOTE*** Please read README before installing\033[0m\n"
echo -n "Press any key to start or crtl+c to quit. "
read var

echo "Please wait....."
echo ""
echo "Making symbolic link to binary..."
ln -sf ${INSTALLER_PATH}/iPodder.sh ${INSTALLER_BIN}/${NAME}
echo "Copying files..."
cp -f -R * ${INSTALLER_PATH}
echo "Installation finished"
echo ""
echo "Please read the files:
	${INSTALLER_PATH}/README
	${INSTALLER_PATH}/Changelog
	${INSTALLER_PATH}/TODO"
echo ""
echo -e "Webiste is at \033[4m${WEBSITE}\033[0m"
echo -e "If you need support goto \033[4m${SUPPORT}\033[0m"
echo ""
echo "You can start ${NAME} with: ${INSTALLER_BIN}/${NAME}"
echo ""


