// -*- C++ -*-
// --------------------------------------------------------------------
// Various utility classes
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEUTILS_H
#define IPEUTILS_H

#include "ipebitmap.h"
#include "ipevisitor.h"
#include "ipepainter.h"

// --------------------------------------------------------------------

class IpePage;

class IPE_EXPORT IpeBitmapFinder : public IpeVisitor {
 public:
  void ScanPage(const IpePage *page);

  virtual void VisitGroup(const IpeGroup *obj);
  virtual void VisitImage(const IpeImage *obj);
  virtual void VisitReference(const IpeReference *obj);
public:
  std::vector<IpeBitmap> iBitmaps;
};

class IPE_EXPORT IpeBBoxPainter : public IpePainter {
public:
  IpeBBoxPainter(const IpeStyleSheet *style);
  IpeRect BBox() const { return iBBox; }

protected:
  virtual void DoMoveTo(const IpeVector &v);
  virtual void DoLineTo(const IpeVector &v);
  virtual void DoCurveTo(const IpeVector &v1, const IpeVector &v2,
			 const IpeVector &v3);
  virtual void DoDrawBitmap(IpeBitmap bitmap);
  virtual void DoDrawText(const IpeText *text);

private:
  void Add(const IpeVector &pos);
  IpeRect iBBox;
  IpeVector iV;
};

class IPE_EXPORT IpeA85Stream : public IpeStream {
public:
  IpeA85Stream(IpeStream &stream);
  virtual void PutChar(char ch);
  virtual void Close();
private:
  IpeStream &iStream;
  uchar iCh[4];
  int iN;
  int iCol;
};

class IPE_EXPORT IpeDeflateStream : public IpeStream {
public:
  IpeDeflateStream(IpeStream &stream, int level);
  virtual ~IpeDeflateStream();
  virtual void PutChar(char ch);
  virtual void Close();

  static IpeBuffer Deflate(const char *data, int size, int &deflatedSize, int compressLevel);

private:
  struct Private;

  IpeStream &iStream;
  Private *iPriv;
  int iN;
  IpeBuffer iIn;
  IpeBuffer iOut;
};

class IPE_EXPORT IpeA85Source : public IpeDataSource {
public:
  IpeA85Source(IpeDataSource &source);
  //! Get one more character, or EOF.
  virtual int GetChar();
private:
  IpeDataSource &iSource;
  bool iEof;
  int iN;
  int iIndex;
  uchar iBuf[4];
};

class IPE_EXPORT IpeInflateSource : public IpeDataSource {
public:
  IpeInflateSource(IpeDataSource &source);
  virtual ~IpeInflateSource();
  //! Get one more character, or EOF.
  virtual int GetChar();

private:
  void FillBuffer();

private:
  struct Private;

  IpeDataSource &iSource;
  Private *iPriv;
  char *iP;
  IpeBuffer iIn;
  IpeBuffer iOut;
};


// --------------------------------------------------------------------
#endif
