// -*- C++ -*-
// --------------------------------------------------------------------
// Creating PDF output
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEPDFWRITER_H
#define IPEPDFWRITER_H

#include "ipebase.h"
#include "ipepage.h"
#include "ipedoc.h"
#include "ipeimage.h"
#include "ipeq.h"

class IpeFontPool;
class QIODevice;

// --------------------------------------------------------------------

class IpePdfWriter {
public:
  IpePdfWriter(QIODevice *dev, const IpeStyleSheet *sheet,
	       int compression, bool cropBox, const IpeRect &media);
  ~IpePdfWriter();

  void EmbedFonts(IpeFontPool *pool);
  void CreatePage(IpePage *page);
  void CreateXmlStream(IpeString xmldata);
  void CreateTrailer(const IpeDocument::SProperties &props);

private:
  int StartObject(int objnum = -1);
  void CreateStream(const char *data, int size);
  void WriteString(IpeString text);
  void CreatePageView(IpePage *page, const IpeView *view);
  void EmbedBitmap(IpeBitmap bitmap);

private:
  QIODevice *iDevice;
  const IpeStyleSheet *iSheet;
  IpeQStream iStream;
  //! Obj id of XML stream.
  int iXmlStreamNum;
  //! Obj id of font resource dictionary.
  int iResourceNum;
  //! Obj id of shading dictionary.
  int iShadingNum;
  //! Compression level (0..9).
  int iCompressLevel;
  //! Use /CropBox.
  bool iCropBox;
  //! Mediabox of document.
  IpeRect iMediaBox;

  std::vector<IpeBitmap> iBitmaps;
  //! Next unused PDF object number.
  int iObjNum;
  //! List of pages, expressed as Pdf object numbers.
  std::vector<int> iPageObjectNumbers;
  //! List of file locations, in object number order (starting with 0).
  std::map<int, long> iXref;
};

// --------------------------------------------------------------------
#endif
