// -*- C++ -*-
// --------------------------------------------------------------------
// Output device for Xpdflib
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef PDFOUTPUTDEV_H
#define PDFOUTPUTDEV_H

#include "ipetext.h"

#include "ipepdflib_p.h"

// --------------------------------------------------------------------

class FTFont;
class IpeFontPool;

class IpeOutputDev: public OutputDev {
public:
  explicit IpeOutputDev(XRef *xref, IpeFontPool *pool,
			IpeText::XForm *xform);
  virtual ~IpeOutputDev();

  //! Does this device use upside-down coordinates?
  /*! (Upside-down means (0,0) is the top left corner of the page.) */
  virtual GBool upsideDown() { return gTrue; }

  //! Does this device use drawChar() or drawString()?
  virtual GBool useDrawChar() { return gTrue; }

  //! Does this device use beginType3Char/endType3Char?
  /*! Otherwise, text in Type 3 fonts will be drawn with
    drawChar/drawString. */
  virtual GBool interpretType3Chars() { return gFalse; }

  virtual void stroke(GfxState *state);

  //----- update text state
  virtual void updateAll(GfxState *state);
  virtual void updateFont(GfxState *state);

  //----- text drawing
  virtual void drawChar(GfxState *state, double x, double y,
			double dx, double dy, double originX, double originY,
			CharCode code, Unicode *u, int uLen);

private:
  XRef *iXRef;			 // the xref table for this PDF file
  IpeFontPool *iFontPool;        // font cache
  IpeText::XForm *iXForm;        // text object being rendered

  GfxFont *iGfxFont;		 // current PDF font
  int iFontObject;               // object number of current font
  double iFontMatrix[4];         // transformation of current font
};

// --------------------------------------------------------------------
#endif
