/*
 * libtu/objlist.h
 *
 * Copyright (c) Tuomo Valkonen 1999-2004. 
 *
 * You may distribute and modify this library under the terms of either
 * the Clarified Artistic License or the GNU LGPL, version 2.1 or later.
 */

#ifndef LIBTU_OBJLIST_H
#define LIBTU_OBJLIST_H

#include "types.h"
#include "obj.h"


INTRSTRUCT(ObjList);


DECLSTRUCT(ObjList){
    Watch watch; /* Must be kept at head of structure */
    ObjList *next, *prev;
    ObjList **list;
};


#define FOR_ALL_ON_OBJLIST(TYPE, VAR, LIST)  \
    for((VAR)=(TYPE)objlist_init_iter(LIST); \
        (VAR)!=NULL;                         \
        (VAR)=(TYPE)objlist_iter())


bool objlist_insert(ObjList **objlist, Obj *obj);
void objlist_remove(ObjList **objlist, Obj *obj);
void objlist_clear(ObjList **objlist);
Obj *objlist_init_iter(ObjList *objlist);
Obj *objlist_iter();

#endif /* LIBTU_OBJLIST_H */
