%{ /* -*- c -*- */

/*********************************************************************
 * Filename:      parser.y
 * Version:       $Id: parser.y,v 1.16 2004/10/03 19:53:15 tfheen Exp $
 * Description:   configuration parser for intuitively
 * Author:        Tollef Fog Heen <tollef@add.no>
 * Created at:    Tue Oct 10 18:05:08 2000
 * Modified at:   Sun Oct  3 17:18:17 2004
 * Modified by:   Tollef Fog Heen <tollef@add.no>
 ********************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include "intuitively.h"
#include <string.h>
#include "utility.h"
#include <libnet.h>
#include <pcap.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,50)
#warn "intuitively needs Linux 2.2+"
#endif

static struct entry *current_entry;

%}

%union {
  char* string;
}
%token <string> HEADER
%token <string> MACADDRESS
%token <string> HEX
%token <string> IPV4
%token <string> IPV6
%token <string> ID
%token <string> PATH
%token <string> NETMASK
%token NETMASK_STR OTHERIP OTHERMAC DEFAULT_GW WIRELESS_KEY WIRELESS_ESSID DESCRIPTION SCRIPT MYIP BROADCAST DONTSETIP DEFAULTLOCATION
%%

statement:   expression statement
           | expression
;

expression:  section
           | myip_with_netmask
           | myip
           | netmask
           | other_ip
           | other_mac_and_ipv4
           | other_mac
           | default_gw
           | wireless_key
           | wireless_essid
           | description
           | script
           | broadcast
           | dontsetip
	   | defaultlocation

;

myip_with_netmask: MYIP '=' IPV4 '/' NETMASK { 
  int ret;
  /*    fprintf(stderr,"myip_with_netmask\n"); */
  if (current_entry->myip.ss_family != 0) {
    fprintf(stderr,"Warning: You have two IP numbers in %s.  Using last one\n",
	    current_entry->dirroot);
  }
  current_entry->myip.ss_family = AF_INET;
  ret = net_aton($3,&current_entry->myip);
  if (!ret) {
    fprintf(stderr,"illegal ip: %s\n",$3);
  }
  if (current_entry->netmask.ss_family) {
    fprintf(stderr,"Warning: two netmasks in %s.  Using last one\n",
	    current_entry->dirroot);
  }
  current_entry->netmask.ss_family = AF_INET;
  ret = parsenetmask($5,&current_entry->netmask);
  if (!ret){
    fprintf(stderr,"illegal netmask: %s\n",$3);
    return -1;
  }
};

myip: MYIP '=' IPV4 { 
  if (current_entry->myip.ss_family) {
    fprintf(stderr,"Warning: You have two IP numbers in %s.  Using last one\n",
	    current_entry->dirroot);
  }
  current_entry->myip.ss_family = AF_INET;
  net_aton($3, &current_entry->myip);
};

myip: MYIP '=' IPV6 { 
  if (current_entry->myip.ss_family) {
    fprintf(stderr,"Warning: You have two IP numbers in %s.  Using last one\n",
	    current_entry->dirroot);
  }
  fprintf(stderr,"ipv6: %s\n", $3);
  current_entry->myip.ss_family = AF_INET6;
  net_aton($3, &current_entry->myip);

};

netmask:  NETMASK_STR '=' NETMASK { 
  if (current_entry->netmask.ss_family) {
    fprintf(stderr,"Warning: two netmasks in %s.  Using last one\n",
	    current_entry->dirroot);
  }
  current_entry->netmask.ss_family = AF_INET;
  parsenetmask($3,&current_entry->netmask);
};

other_ip:  OTHERIP '=' IPV4 {
  current_entry->pingip[current_entry->pingips].ip.ss_family = AF_INET;
  current_entry->pingip[current_entry->pingips].mac = NULL;
  net_aton($3, &current_entry->pingip[current_entry->pingips++].ip); 
};

other_mac_and_ipv4:  OTHERIP '=' IPV4 '=' MACADDRESS {
  current_entry->pingip[current_entry->pingips].ip.ss_family = AF_INET;
  current_entry->pingip[current_entry->pingips].mac = strdup($5);
  net_aton($3, &current_entry->pingip[current_entry->pingips++].ip);
};

other_mac:  OTHERMAC '=' MACADDRESS {
  if (current_entry->pingips == 0) 
    fprintf(stderr, "other_mac before ip address, ignoring\n");
  else 
    current_entry->pingip[current_entry->pingips - 1].mac = strdup($3);
  /*  net_aton($3, &current_entry->pingip[current_entry->pingips++].ip);*/
};

default_gw:  DEFAULT_GW '=' IPV4 {
  if (current_entry->gw.ss_family) {
    fprintf(stderr,"Warning: two gateways in %s.  Using last one\n",
	    current_entry->dirroot);
  }
  current_entry->gw.ss_family = AF_INET;
  net_aton($3,&current_entry->gw); 
};

broadcast:  BROADCAST '=' IPV4 { 
  if (current_entry->broadcast.ss_family) {
    fprintf(stderr,"Warning: two broadcast addresses in %s.  Using last one\n",
	    current_entry->dirroot);
  }
  current_entry->broadcast.ss_family = AF_INET;
  net_aton($3, &current_entry->broadcast); 
};

wireless_key:  WIRELESS_KEY '=' HEX { 
  if (current_entry->wireless_key) {
    fprintf(stderr,"Warning: two wireless keys in %s.  Using last one\n",
	    current_entry->dirroot);
    free(current_entry->wireless_key);
  }
  current_entry->wireless_key = $3; 
};

wireless_essid:  WIRELESS_ESSID '=' ID { 
  if (current_entry->wireless_essid) {
    fprintf(stderr,"Warning: two wireless essids in %s.  Using last one\n",
	    current_entry->dirroot);
    free(current_entry->wireless_essid);
  }
  current_entry->wireless_essid = $3; 
};

description:  DESCRIPTION '=' ID { 
  if (current_entry->description) {
    fprintf(stderr,"Warning: two descriptions in %s.  Using last one\n",
	    current_entry->dirroot);
    free(current_entry->description);
  }
  current_entry->description = $3; 
};

script:  SCRIPT '=' PATH {
  if (current_entry->script) {
    fprintf(stderr,"Warning: two scripts in %s.  Using last one\n",
	    current_entry->dirroot);
    free(current_entry->script);
  }
  current_entry->script = $3; 
};

dontsetip: DONTSETIP {
  current_entry->dontsetip = 1;
};

defaultlocation: DEFAULTLOCATION {
  current_entry->defaultlocation = 1;
};

section: '[' ID ']' { 
  current_entry = e;

  if (current_entry->description != NULL) {
    while (current_entry->next != NULL) {
      current_entry = current_entry->next;
    }
    current_entry->next = (struct entry*)malloc(sizeof(struct entry));
    current_entry = current_entry->next;
    memset(current_entry,'\0',sizeof(struct entry));
  }
  /*  printf("yacc: Header: %s\n",$2);*/
  current_entry->dirroot = $2;
  current_entry->name = $2;
};

%%
