/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright (C) chaitanya chandel 2009 <cchandel@yahoo.com>
 * 
 * dbus-stuff.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * dbus-stuff.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dbus-stuff.h"
#include <string.h>
#include <E_DBus.h>
#include <Elementary.h>

void occupy_cpu(void)
{	
	e_dbus_init();
	conn = e_dbus_bus_get(DBUS_BUS_SYSTEM);
	
	DBusMessage *msg;
	msg = dbus_message_new_method_call(
		"org.freesmartphone.ousaged",
		"/org/freesmartphone/Usage",
		"org.freesmartphone.Usage",
		"RequestResource"
	);
	
	const char *resource = "CPU";
	dbus_message_append_args (msg, DBUS_TYPE_STRING, &resource, DBUS_TYPE_INVALID);

	e_dbus_message_send(conn, msg, dbus_reply_cb, -1, NULL);
	dbus_message_unref(msg);
}

void release_cpu(void)
{
	DBusMessage *msg;
	msg = dbus_message_new_method_call(
		"org.freesmartphone.ousaged",
		"/org/freesmartphone/Usage",
		"org.freesmartphone.Usage",
		"ReleaseResource"
	);
	
	const char *resource = "CPU";
	dbus_message_append_args (msg, DBUS_TYPE_STRING, &resource, DBUS_TYPE_INVALID);

	e_dbus_message_send(conn, msg, dbus_reply_cb, -1, NULL);
	dbus_message_unref(msg);
}

void dbus_reply_cb(void *data, DBusMessage *replymsg, DBusError *error)
{
	if (dbus_error_is_set(error)) {
		printf("Error: %s - %s\n", error->name, error->message);
	}
}

void incoming_call_listener(void)
{
	e_dbus_signal_handler_add(conn, 
	                          "org.freesmartphone.ogsmd", 
	                          "/org/freesmartphone/GSM/Device", 
	                          "org.freesmartphone.GSM.Call", 
	                          "CallStatus", 
	                          pause_on_call, NULL);
}

void pause_on_call(void *data, DBusMessage *msg)
{
	int id, ret;
	char *status=NULL, ***prop, cmd[255];
	DBusError *error=NULL;
	
	dbus_message_get_args(msg, error,
	                      DBUS_TYPE_INT32, &id,
	                      DBUS_TYPE_STRING, &status,
	                      DBUS_TYPE_ARRAY, &prop, DBUS_TYPE_INVALID);
	if ((strcmp(status, "incoming") == 0) && (play_state==PLAYING)) {
		play_button_clicked (NULL, NULL, NULL);
		PHONE = 1;
		//alsa state set automatically
		//elm_win_lower(win);
	}
	if ((strcmp(status, "outgoing") == 0) && (play_state==PLAYING)) {
		play_button_clicked (NULL, NULL, NULL);
		PHONE = 1;
	}
	if ((strcmp(status, "release") == 0) && (play_state==PAUSE) && (PHONE)) {
		sleep(3);
		//restore intone volume
		sprintf(cmd, "amixer -c 0 set PCM %d%s", vol, "\%\n");
		ret = write(fd, cmd, strlen(cmd));
		ret = system(cmd);

		//restore bass
		sprintf(cmd, "amixer -c 0 set Bass %d\n", bass);
		ret = write(fd, cmd, strlen(cmd));
		ret = system(cmd);
		
		//restore treble
		sprintf(cmd, "amixer -c 0 set Treble %d\n", treble);
		ret = write(fd, cmd, strlen(cmd));
		ret = system(cmd);

		PHONE = 0;
		play_button_clicked (NULL, NULL, NULL);	
	}
	//TODO: get prop data too
}

void bluetooth_on(void)
{
	DBusMessage *msg;
	msg = dbus_message_new_method_call(
		"org.freesmartphone.odeviced",
		"/org/freesmartphone/Device/PowerControl/Bluetooth",
		"org.freesmartphone.Device.PowerControl",
		"SetPower"
	);
	int resource = 1;
	dbus_message_append_args (msg, DBUS_TYPE_BOOLEAN, &resource, DBUS_TYPE_INVALID);

	e_dbus_message_send(conn, msg, dbus_reply_cb, -1, NULL);
	dbus_message_unref(msg);
}

void bluetooth_off(void)
{
	DBusMessage *msg;
	msg = dbus_message_new_method_call(
		"org.freesmartphone.odeviced",
		"/org/freesmartphone/Device/PowerControl/Bluetooth",
		"org.freesmartphone.Device.PowerControl",
		"SetPower"
	);
	int resource = 0;
	dbus_message_append_args (msg, DBUS_TYPE_BOOLEAN, &resource, DBUS_TYPE_INVALID);

	e_dbus_message_send(conn, msg, dbus_reply_cb, -1, NULL);
	dbus_message_unref(msg);
}
