/*****************************************************************************

NAME
    bin2c.c -- convert a binary data file to a C source file

LICENSE TERMS
    Copyright (C) 2007 Alex Smith

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#include <stdio.h>

int main(int argc, char** argv)
{
  int c,colno;
  if(argc!=2)
  {
    fprintf(stderr,"Usage: bin2c varname < infile > outfile\n");
    return 0;
  }
  (void) puts("/* This file is automatically generated; to modify it,");
  (void) puts("   modify the source file, not this file. */");
  printf("char* %s=\"\\\n",argv[1]);
  colno=0;
  while((c=getchar())!=EOF)
  {
    printf("\\x%02x",(unsigned)c);
    colno+=4;
    if(colno>70) {(void) puts("\\"); colno=0;}
  }
  (void) puts("\";");
  return 0;
}
