/***************************************************************************
                       basecontroller.cpp  -  description                              
                          -------------------                                         
 begin                : Thu Oct 7 1999                                           
 copyright            : (C) 1999 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "basecontroller.h"
#include "Entities/controller.h"
#include "Modifiers/animtoolbar.h"
#include "i3ddoc.h"
#include "i3d.h"

BaseController *BaseController::bc = 0;


BaseController::BaseController( ) : QObject(), m_controllers(), m_timer()
{
  time = 1;
  max_time = 1;
  direction = 1;
  connect( &m_timer, SIGNAL( timeout() ), SLOT( tick() ) );
}

BaseController::~BaseController()
{}

void BaseController::checkMaxTime( int x )
{
  if ( x > max_time )
  {
    max_time = x;
    AnimToolbar::getInstance() -> setMax( max_time );
  }
}

void BaseController::checkMaxTime( )
{
  printf( "Checking max time:\n" );
  ControllerIterator it = m_controllers.begin();

  while ( it != m_controllers.end() )
  {
    printf( "Checking : %d\n", ( *it ) -> getMaxTime() );
    checkMaxTime( ( *it ) -> getMaxTime() );
    ++it;
  }
}


void BaseController::saveKeyframe( int x )
{
  checkMaxTime( x );

  time = x;

  ControllerIterator it = m_controllers.begin();

  while ( it != m_controllers.end() )
  {
    ( *it ) -> saveTime( time );

    ++it;
  }



}

void BaseController::deleteKeyframe( int )
{}

void BaseController::playForward()
{
  direction = 1;
  m_timer.start( 0 );
}

void BaseController::playReverse()
{
  direction = -1;
  m_timer.start( 0 );
}

void BaseController::gotoFirst()
{
  setTime( 1 );
}

void BaseController::gotoLast()
{
  setTime( max_time );
}

void BaseController::stop()
{
  m_timer.stop();
}

void BaseController::addController( Controller *c )
{
  m_controllers.push_back( c );
}

void BaseController::removeController( Controller *c )
{
  m_controllers.remove( c );
}


void BaseController::setTime( int i )
{
  if ( i == time )
    return ;

  time = i;


  ControllerIterator it = m_controllers.begin();

  while ( it != m_controllers.end() )
  {
    //update controllers.

    ( *it ) -> loadTime( time );
    ++it;
  }

  //update AnimToolbar
  AnimToolbar::getInstance() -> setTime( time );

  I3D::getInstance() -> updateViews();
}


BaseController * BaseController::getInstance()
{
  if ( bc == 0 )
    bc = new BaseController();

  return bc;
}

void BaseController::tick()
{
  int i = time + direction;

  if ( max_time == 1 )
  {
    return ;
  }

  if ( i > max_time )
  {
    cerr << "looping" << endl;
    i = 1;
  }

  if ( i < 1 )
  {
    cerr << "looping backward" << endl;
    i = max_time;
  }

  setTime( i );
}




