/***************************************************************************
                          util.cpp  -  description
                             -------------------
    begin                : Wed Nov 1 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "util.h"
#include <algorithm>
#include <Entities/object.h>
#include <qfiledialog.h>
#include <i3d.h>
#include <config.h>
#include <qstringlist.h>

/** Assumes narray has been sized already.
 */
void Util::convertToArray( vector<int> &v, int *narray )
{
	for( int i=0; i<(int)v.size(); i++ )
	{
		narray[i] = v[i];
	}
}

void Util::convertToVector( int *narray, int n, vector<int> &v )
{
	v.clear(); //just incase;
	for(int i=0; i< n; i++ )
	{
		v.push_back(narray[i]);
	}
}
	
void Util::dump( vector<int> & v )
{
	for(unsigned int i=0; i<v.size(); i++){
		cerr<<v[i]<<" ";
	}
	cerr<<endl;

}

void Util::removeDuplicates(vector<int> &v)
{
	vector<int>::iterator start = ::unique(v.begin(), v.end());
	v.erase(start, v.end());
}


void Util::dump( Object *o )
{
	cerr << "Object:"<<endl;
	cerr << "\tVerts:"<<o -> numVerts()<<endl;
	cerr << "\tEdges:"<<o -> numEdges()<<endl;
	cerr << "\tFaces:"<<o -> numFaces()<<endl;
	cerr << "\tUVs:"  <<o -> numUVs()<<endl;

}

QImage * Util::loadImage( )
{
  QString filename;
  QString filter;
  QStringList sl;
  static QString directory = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str();
  QString tmp;

  QFileDialog *fd = new QFileDialog( directory, QString::null, 0, 0, true );

  directory = QString::null;

  sl = QImage::inputFormatList();

   for ( QStringList::Iterator it = sl.begin(); it != sl.end(); ++it )
   {
      tmp = "*.";
      tmp.append( (*it).lower() );
      (*it) = tmp;
  }

  fd -> setFilters( sl );

  fd -> setMode( QFileDialog::ExistingFile );
  QImage *img = 0;
  if( ! fd -> exec() )
  {

      filename = fd -> selectedFile();
      filter = fd -> selectedFilter();
      filter = filter.right(4);

      //add the extension if necessary.
      if(filename.right(4) != filter) {
         filename.append( filter );
      }
      //replace with a dictionary lookup of formats->extensions.
       img = new QImage( filename, filter.right(3).upper() );

  }
   delete fd;
   return img;

}
void Util::saveImage( QImage * img)
{
  QString filename;
  QString filter;
  QStringList sl;
  static QString directory = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str();
  QString tmp;

  QFileDialog *fd = new QFileDialog( 0, QString::null, 0, 0, true );

  directory = QString::null;

  sl = QImage::outputFormatList();

   for ( QStringList::Iterator it = sl.begin(); it != sl.end(); ++it )
   {
      tmp = "*.";
      tmp.append( (*it).lower() );
      //fd -> addFilter( tmp );
      (*it) = tmp;

  }

  fd -> setFilters( sl );

  fd -> setMode( QFileDialog::AnyFile );
  if( fd -> exec() )
  {
      filename = fd -> selectedFile();
      filter = fd -> selectedFilter();
      filter = filter.right(4);

      //add the extension if necessary.
      if(filename.right(4) != filter) {
         filename.append( filter );
      }

      //replace with a dictionary lookup of formats->extensions.
      img -> save( filename, filter.right(3).upper() );
  }

  delete fd;

}
/*
JPEG  ( *.jpg *.jpeg )
PNG   ( *.png )
XPM   ( *.xpm *.xbm )
TIFF  ( *.tif )
TARGA ( *.tga )
GIF   ( *.gif )
PPM   ( *.ppm *.pgm *.pbm )
BMP   ( *.bmp )
SGI   ( *.sgi *.rgb *.rgba *.bw )
*/

