#ifndef CBONEDLG_H
#define CBONEDLG_H

#include "icbonedlg.h"
#include "floatspinner.h"
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <string>

using namespace std;

class CBoneDlg : public ICBoneDlg
{
      Q_OBJECT

   public:
      CBoneDlg( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
      ~CBoneDlg();

      int getA() { return spnA -> value(); };

      int getB() { return spnB -> value(); };

      int getC() { return spnC -> value(); };

      int getD() { return spnD -> value(); };

      int getE() { return spnE -> value(); };

      int getF() { return spnF -> value(); };

      int getStiffness() { return spnStiffness -> value(); };

//      float getLength() { return (float)spnLength -> value() / 10; };

      void setA( int i ) { spnA -> setValue( i ); };

      void setB( int i ) { spnB -> setValue( i ); };

      void setC( int i ) { spnC -> setValue( i ); };

      void setD( int i ) { spnD -> setValue( i ); };

      void setE( int i ) { spnE -> setValue( i ); };

      void setF( int i ) { spnF -> setValue( i ); };

      void setStiffness( int i ) { spnStiffness -> setValue( i ); };

//      void setLength( float i ) { spnLength -> setValue( (int)i*10); };

      void setName( string s ) { fldName -> setText( s.c_str() ); };

      void setNotes( string s ) { fldNotes -> setText( s.c_str() ); };

      QString getName() { return fldName -> text(); };

      QString getNotes() { return fldNotes -> text(); };

};

#endif // CBONEDLG_H
