/***************************************************************************
                         AnimToolbar.cpp  -  description
                            -------------------
   begin                : Mon Apr 16 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "animtoolbar.h"
#include <qpixmap.h>
#include <qvalidator.h>
#include <qstring.h>

#include <Xpm/play_stop.xpm>
#include <Xpm/play_start.xpm>
#include <Xpm/play_back.xpm>
#include <Xpm/play_forward.xpm>
#include <Xpm/play_end.xpm>
#include <Xpm/delete_keyframe.xpm>
#include <Xpm/save_keyframe.xpm>

#include <stdlib.h>
#include <iostream>
#include <assert.h>

#include "basecontroller.h"

AnimToolbar * AnimToolbar::m_instance = 0;

AnimToolbar * AnimToolbar::getInstance()
{
   if ( m_instance == 0 )
   {
      cerr << "Creating anim bar." << endl;
      m_instance = new AnimToolbar();
   }

   return m_instance;
}
AnimToolbar::AnimToolbar() : QObject()
{
}

void AnimToolbar::init( QToolBar *b )
{

   m_toolbar = b;

   btnDelete = new QToolButton( QPixmap( ( const char ** ) ::delete_keyframe ),
                          "Delete Keyframe",
                          "",
                          0,
                          0 ,
                          m_toolbar );

   btnSave = new QToolButton( QPixmap( ( const char ** ) ::save_keyframe ),
                          "Save Keyframe",
                          "",
                          0,
                          0,
                          m_toolbar );

	fldKeyframe = new QLineEdit( "1", m_toolbar,  "");
	fldKeyframe -> setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, fldKeyframe->sizePolicy().hasHeightForWidth() ) );
  fldKeyframe -> setMaximumSize( QSize( 50, 32767 ) );
  fldKeyframe -> setMaxLength( 4 );
	fldKeyframe -> setValidator( new QIntValidator( 1, 9999, fldKeyframe, "" ) );
   m_toolbar -> addSeparator();
	
	
   btnStart = new QToolButton( QPixmap( ( const char ** ) ::play_start ),
                          "First Keyframe",
                          "",
                          0,
                          0,
                          m_toolbar );

   btnReverse = new QToolButton( QPixmap( ( const char ** ) ::play_back ),
                          "Play in Reverse",
                          "",
                          0,
                          0,
                          m_toolbar );


   btnStop = new QToolButton( QPixmap( ( const char ** ) ::play_stop ),
                          "Stop",
                          "",
                          0,
                          0,
                          m_toolbar );

   btnPlay = new QToolButton( QPixmap( ( const char ** ) ::play_forward ),
                          "Play forward",
                          "",
                          0,
                          0,
                          m_toolbar );

   btnEnd = new QToolButton( QPixmap( ( const char ** ) ::play_end ),
                          "Last Keyframe",
                          "",
                          0,
                          0,
                          m_toolbar );

   m_toolbar -> addSeparator();

  sldrKeyframe = new QSlider( m_toolbar );
	sldrKeyframe -> setOrientation( QSlider::Horizontal );
  sldrKeyframe -> setTickmarks( QSlider::Left );
	sldrKeyframe -> setTickInterval( 5 );
	sldrKeyframe -> setMinValue( 1 );
	sldrKeyframe -> setMaxValue( 100 );
  m_toolbar -> setStretchableWidget( sldrKeyframe );

  connect( btnDelete, SIGNAL(clicked()), SLOT(slotDelete()) );
	connect( btnSave,   SIGNAL(clicked()), SLOT(slotSave()) );
	connect( btnStop, SIGNAL(clicked()), SLOT(slotStop()) );
	connect( btnStart, SIGNAL(clicked()), SLOT(slotStart()) );
	connect( btnEnd, SIGNAL(clicked()), SLOT(slotEnd()) );	
	connect( btnPlay, SIGNAL(clicked()), SLOT(slotPlay()) );
	connect( btnReverse, SIGNAL(clicked()), SLOT(slotReverse()) );	
	connect( sldrKeyframe, SIGNAL(valueChanged(int)), SLOT(slotSlider(int)) );
}

AnimToolbar::~AnimToolbar()
{
}

void AnimToolbar::slotPlay()
{
	cerr << "Playing..." << endl;
	BaseController::getInstance() -> playForward();
}

void AnimToolbar::slotReverse()
{
	cerr << "Playing in Reverse..." << endl;
	BaseController::getInstance() -> playReverse();	
}

void AnimToolbar::slotStop()
{
	cerr << "Stopping..." << endl;
	BaseController::getInstance() -> stop();
}
void AnimToolbar::slotEnd()
{
	cerr << "Going to last keyframe..." << endl;
	BaseController::getInstance() -> gotoLast();
}
void AnimToolbar::slotStart()
{
	cerr << "Going to first keyframe..." << endl;
	BaseController::getInstance() -> gotoFirst();
}
void AnimToolbar::slotSave()
{
	cerr << "Saving keyframe..." << endl;
	BaseController::getInstance() -> saveKeyframe( getTime() );
	setTime( getTime() );
}
void AnimToolbar::slotDelete()
{
	cerr << "Deleting keyframe..." << endl;
	BaseController::getInstance() -> deleteKeyframe( getTime() );	
}

void AnimToolbar::slotSlider(int x )
{
//	cerr << "Current Keyframe -> " << x << endl;
	setTime( x );
	BaseController::getInstance() -> setTime( x );
}
void AnimToolbar::setTime( int x )
{
	QString s;
	s.setNum( x );
	sldrKeyframe -> setValue( x );	
	fldKeyframe -> setText( s );
}
void AnimToolbar::setMax( int x )
{

	sldrKeyframe -> setMaxValue( x );
	
	int step = (x / 20);
	sldrKeyframe -> setTickInterval( step );
		
}

int AnimToolbar::getTime()
{
	QString s = fldKeyframe -> text();
	
	return s.toInt();
	
}




