//
// (c) Polar Pyramid                                                                                                             
// suggestions to stolken@kabelfoon.nl and/or stolk@xs4all.nl
//

#include <assert.h>
#include <math.h>

#include "vector3.h"
#include "vector4.h"
#include <iostream>

using namespace std;
/////////////////////////////////////////////////////////////////////////////
//
// Default Constructor
//

 Vector4::Vector4()

{
	x=0;
	y=0;
	z=0;
	w=0;
	interp = true;
}

/////////////////////////////////////////////////////////////////////////////
//
// Copy Constructor
//

 Vector4::Vector4(const Vector4& v2)
{
	x = v2.x;
	y = v2.y;
	z = v2.z;
	w = v2.w;
	interp = v2.interp;
	interp = true;
}

/////////////////////////////////////////////////////////////////////////////
//
// Element Constructor
//

 Vector4::Vector4(float ix, float iy, float iz, float iw)

{
	x=ix;
	y=iy;
	z=iz;
	w=iw;
	interp = true;
}
///////////////////////////////////////////////////////////////////
//
// Interpolation properties
//
 bool Vector4::isInterpolatable(){
	return interp;
}

 void Vector4::setInterpolatable(bool flag)
{
	interp = flag;
}

/////////////////////////////////////////////////////////////////////////////
//
// Array Access
//

 float& Vector4::operator [](int i)
{
  switch (i)
  {
  case 0: return x;
  case 1: return y;
  case 2: return z;
  case 3: return w;
  }
  assert(false);
  return x;
}


 const float& Vector4::operator [](int i) const
{
  assert(i >= 0 && i <= 3);
  switch (i)
  {
  case 0: return x;
  case 1: return y;
  case 2: return z;
  case 3: return w;
  }
  assert(false);
  return x;
}

/////////////////////////////////////////////////////////////////////////////
//
// Assignment
//

 Vector4& Vector4::assign(float ix, float iy, float iz, float iw)
{
  x = ix;
  y = iy;
  z = iz;
  w = iw;
  return *this;
}

/////////////////////////////////////////////////////////////////////////////
// Math Operators
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// - Vector4
//

 Vector4 Vector4::operator -() const
{
  return Vector4(-x, -y, -z, -w);
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 += Vector4
//

 Vector4& Vector4::operator += (const Vector4& v2)
{
  x += v2.x;
  y += v2.y;
  z += v2.z;
  w += v2.w;
  return *this;
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 -= Vector4
//

 Vector4& Vector4::operator -= (const Vector4& v2)
{
  x -= v2.x;
  y -= v2.y;
  z -= v2.z;
  w -= v2.w;
  return *this;
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 += Vector3
//

 Vector4& Vector4::operator += (const Vector3& v2)
{
  x += v2.x;
  y += v2.y;
  z += v2.z;
  return *this;
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 -= Vector3
//

 Vector4& Vector4::operator -= (const Vector3& v2)
{
  x -= v2.x;
  y -= v2.y;
  z -= v2.z;
  return *this;
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 *= float
//


 Vector4& Vector4::operator *= (float c)
{
  x *= c;
  y *= c;
  z *= c;
  w *= c;
  return *this;
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 /= float
//


 Vector4& Vector4::operator /= (float c)
{
  x /= c;
  y /= c;
  z /= c;
  w /= c;
  return *this;
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 + Vector4
//


 Vector4 Vector4::operator + (const Vector4& v2) const
{
  return Vector4(x + v2.x,
		 y + v2.y,
		 z + v2.z,
		 w + v2.w);
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 - Vector4
//


 Vector4 Vector4::operator - (const Vector4& v2) const
{
  return Vector4(x - v2.x,
		 y - v2.y,
		 z - v2.z,
		 w - v2.w);
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 + Vector3
//


 Vector4 Vector4::operator + (const Vector3& v2) const
{
  return Vector4(x + v2.x,
		 y + v2.y,
		 z + v2.z,
		 w);
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 - Vector3
//


 Vector4 Vector4::operator - (const Vector3& v2) const
{
  return Vector4(x - v2.x,
		 y - v2.y,
		 z - v2.z,
		 w);
}


/////////////////////////////////////////////////////////////////////////////
//
// Vector4 / float
//


 Vector4 Vector4::operator / (float c) const
{
  assert(c != 0);
  return Vector4(x/c,
		 y/c,
		 z/c,
		 w/c);
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 == Vector4
//


 bool Vector4::operator == (const Vector4& v2) const
{
  return ((x == v2.x) &&
          (y == v2.y) &&
          (z == v2.z) &&
          (w == v2.w));
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 != Vector4
//


 bool Vector4::operator != (const Vector4& v2) const
{
  return (!(*this == v2));
}

/////////////////////////////////////////////////////////////////////////////
//
// float * Vector4
//

 Vector4 operator * (float c, Vector4 const &v2)
{
  return Vector4(v2.x*c,
		 v2.y*c,
		 v2.z*c,
		 v2.w*c);
}

/////////////////////////////////////////////////////////////////////////////
//
// Vector4 * float
//


 Vector4 operator * (Vector4 const &v2, float c)
{
  return Vector4(v2.x*c,
		 v2.y*c,
		 v2.z*c,
		 v2.w*c);
}
 void Vector4::min(Vector4 const &v2)
{
 if(v2.x < x)
 	x = v2.x;
 if(v2.y < y)
 	y = v2.y;
 if(v2.z < z)
 	z = v2.z;
}
 void Vector4::max(Vector4 const &v2)
{
 if(v2.x > x)
 	x = v2.x;
 if(v2.y > y)
 	y = v2.y;
 if(v2.z > z)
 	z = v2.z;
}

 void Vector4::Dump(void) const
{
  cerr << "Vector4 " << x << "," << y << "," << z <<  "," << w << "\n";
}

/////////////////////////////////////////////////////////////////////////////
//
// length : returns the length of the vector4 as a float, note that
//          this has to return a float because it uses the sqrt function
//

 float Vector4::length() const
{
  return sqrt(lengthSqr());
}

/////////////////////////////////////////////////////////////////////////////
//
// lengthSqr : returns the squared length of the vector4
//


 float Vector4::lengthSqr() const
{
  return x*x + y*y + z*z + w*w;
}

/////////////////////////////////////////////////////////////////////////////
//
// length3d : returns the length of the vector4 as a float, note that
//          this has to return a float because it uses the sqrt function
//


 float Vector4::length3d() const
{
  return sqrt(lengthSqr3d());
}

/////////////////////////////////////////////////////////////////////////////
//
// lengthSqr3d : returns the squared 3d length of the vector4
//

 float Vector4::lengthSqr3d() const
{
  return x*x + y*y + z*z;
}

/////////////////////////////////////////////////////////////////////////////
//
// normalize : will normalize the vector4, make it of length 1
//

 void Vector4::normalize(void)
{
  float len = length3d();
  if (len != 0.0)
    *this /= ((float) len);      // avoid SIGFPE
}

//
// ToVector3
//

 Vector3 Vector4::ToVector3(void) const
{
  return Vector3(x, y, z);
}

 float * Vector4::v(float *v) const
{
 v[0] = x;
 v[1] = y;
 v[2] = z;
 v[3] = w;

 return v;
}
/////////////////////////////////////////////////////////////////////////////
//
// dot : returns the dot product of 2 vectors
//

 float Vector4::dot(const Vector4& v2) const
{
  return x*v2.x + y*v2.y + z*v2.z + w*v2.w;
}

/////////////////////////////////////////////////////////////////////////////
//
// dot3d : returns the dot product of 2 vector4s for 3d only
//

 float Vector4::dot3d(const Vector4& v2) const
{
  return x*v2.x + y*v2.y + z*v2.z;
}

/////////////////////////////////////////////////////////////////////////////
//
// distanceSqr : return the squared distance between 2 given points which
//               avoids taking an expensive sqrt call. Usefull when comparing
//               different distances.
//

 float Vector4::distanceSqr(const Vector4& v2)
{
  return
  (x - v2.x)*(x-v2.x) +
	(y - v2.y)*(y-v2.y) +
	(z - v2.z)*(z-v2.z) +
	(w - v2.w)*(w-v2.w);
}

/////////////////////////////////////////////////////////////////////////////
//
// distance : return the distance between 2 given points, note that
//            this has to return a float because it uses the sqrt function
//

 float Vector4::distance(const Vector4& v2)
{
  return sqrt(distanceSqr(v2));
}

/////////////////////////////////////////////////////////////////////////////
//
// distanceSqr3d : return the squared distance between 2 given points in 3d
//                 only (z is ignored)
//

 float Vector4::distanceSqr3d(const Vector4& v2)
{
  return
  (x - v2.x)*(x-v2.x) +
	(y - v2.y)*(y-v2.y) +
	(z - v2.z)*(z-v2.z);
}

/////////////////////////////////////////////////////////////////////////////
//
// distance : return the distance between 2 given points, note that
//            this has to return a float because it uses the sqrt function
//

 float Vector4::distance3d(const Vector4& v2)
{
  return sqrt(distanceSqr3d(v2));
}

/*
*
* intersectPlane : returns the intersection point of this vector's line]
* and the given plane.
* if the line does not intersect, or is contained with in the plane
* it returns (0, 0, 0, 0);
*
* l1 and l2 are points on the line.
*/
 Vector4 Vector4::intersectPlane(const Vector4 &l1, const Vector4 &plane) const
{
	//the vector values of the plane are the coefficients in the plane
	//equation.

	float i, j, k;
	float num, den, t;
	
	i = x - l1.x;
	j = y - l1.y;
	k = z - l1.z;
	
	num = plane.x*l1.x + plane.y*l1.y + plane.z*l1.z;// + plane.w;
	den = plane.x*i + plane.y*j + plane.z*k;	
	
	if(num == 0 || den == 0)
		return Vector4(0, 0, 0, 0);
		
	t = -(num/den);
	
	return Vector4(l1.x +i*t,
								 l1.y +j*t,
								 l1.z +k*t, 1);


}



