/***************************************************************************
                          bfstream.h  -  description
                             -------------------
    begin                : Sat, Feb 2, 2002
    copyright            : (C) 2002 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <stdlib.h>
#include <fstream.h>
#include <string.h>

class bfstream : public fstream
{
public:
	bfstream( const char *fn) : fstream(fn, ios::in | ios::out | ios::binary) {};
  void writeBytes(const void *, int );
  void readBytes( void *, int );
  template <class T> bfstream & operator<< (const T & data );
  template <class T> bfstream & operator>> (T & data );
  bfstream & operator<<(const char * data );
};


class bofstream : public ofstream
{
public:
 	bofstream( const char *&fn ) : ofstream( fn, ios::out | ios::binary ) {}
  void writeBytes( const void *, int );
  template <class T> bofstream & operator<<(const T & data);
  bofstream & operator<<(const char * data );
};

class bifstream : public ifstream
{
	public:
  	bifstream(const char *&fn) : ifstream(fn, ios::in | ios::binary) {}
    void readBytes(const void *, int );
    template <class T> bofstream & operator>>(const T & data);
};


template <class T>
bfstream & bfstream::operator<< (const T & data )
{
	writeBytes( &data, sizeof(data) );
  return *this;
}

bfstream & bfstream::operator<<(const char * data )
{
	writeBytes( data, strlen(data) );
	return *this;
}


template <class T>
bfstream & bfstream::operator>> (T & data )
{
	readBytes( &data, sizeof(data) );
  return *this;
}


template <class T>
bofstream & bofstream::operator<<(const T & data)
{
	writeBytes( &data, sizeof(data) );
  return *this;

}
bofstream & bofstream::operator<<(const char * data )
{
	writeBytes( data, strlen(data) );
	return *this;
}

template <class T>
bofstream & bifstream::operator>>(const T & data)
{
	readBytes( &data, sizeof(data) );
  return *this;

}


