/***************************************************************************
                        vertex.h  -  description                              
                           -------------------                                         
  begin                : Sat Aug 14 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef VERTEX_H
#define VERTEX_H

//local includes
#include "object.h"
#include "subobject.h"
#include <math.h>

class Triangle;

class Material;

class Face;
/**
 *
 *  A vertex's position is relative to it's parent.
 * @author Jonathan E. Anderson
 */

#define VERTEX_COLOR    0x00000100
#define VERTEX_NORMAL   0x00000200
#define VERTEX_COORD    0x00000400



class Vertex : public SubObject
{

public:
   Vertex( float x, float y, float z, Object *parent );
   Vertex( Vector4 &p, Object *parent );
   Vertex( Object *parent );

   virtual ~Vertex();

   void setMaterial( TextureMaterial *m );

   void setUVCoord( float u, float v );
   virtual int draw( int draw );

   virtual void rotate( float amount, float x, float y, float z, float, float, float );
   virtual void scale( float, float, float, float ox = 0, float oy = 0, float oz = 0 );
   virtual void move( float, float, float );
   void moveUV( float x, float y, float z );

   virtual void loadKeyframe( Keyframe * );
   virtual void saveKeyframe( Keyframe * );


   void normalize();
   void setRotation( Quat &q );


   Vector4 &getNormal()
   {
      return normal;
   };

   Vector4 &getColor()
   {
      return color;
   };

   bool isColored()
   {
      return m_colored;
   };

   void setColor( float, float, float, float );
   void resetColor();

   void setNormal( float, float, float );
   void setFaceUV( Vector4 & );


   Vertex & operator=( Vertex &rhs );
   void copyFrom( SubObject * );

   Vertex * clone();

   Vector4 getSmoothPosition( float tolerance );

   int getMidpoint( int v1 );

   virtual bool isDeletable();

   static int TYPE;

   virtual void setPosition( float x, float y, float z )
   {
      pos.assign( x, y, z, 1 );
   };

   virtual void setPosition( Vector4 &p )
   {
      pos = p;
   };

   virtual Vector4 & getPosition()
   {
      return pos;
   };

   virtual void getTransformedPosition( Vector4 * );
   virtual void getBoundingMin( Vector4 *v );
   virtual void getBoundingMax( Vector4 *v );
   void getPosition( Vector4 * v )
   {
      *v = pos;
   };



protected:
   TextureMaterial *tm;

   Vector4 normal;
   Vector4 pos;
   Vector4 color;

   bool m_colored;

};

#endif



















