/***************************************************************************
                       sphere.cpp  -  description                              
                          -------------------                                         
 begin                : Tue Aug 3 1999                                           
 copyright            : (C) 1999 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "sphere.h"
#include "vertex.h"
#include "face.h"
#include "nurbssurface.h"
#include <algorithm>


Sphere::Sphere( float x, float y, float z, int _radius, int lod )
    : Mesh( x, y, z )
{
  m_radius = _radius;

  float X = 0.525731112119133606;
  float Z = 0.850650808352039932;

  //base is 12 verts with 20 sides.
  float vdata[ 12 ][ 3 ] = {{ -X, 0, Z}, { X, 0, Z}, { -X, 0, -Z}, {X, 0, -Z},
                            { 0, Z, X}, { 0, Z, -X}, {0, -Z, X}, {0, -Z, -X},
                            {Z, X, 0}, { -Z, X, 0}, {Z, -X, 0}, { -Z, -X, 0}
                           };

  //set up the faces...
  int fdata[ 20 ][ 3 ] = {{0, 4, 1}, {0, 9, 4}, {9, 5, 4}, {4, 5, 8}, {4, 8, 1},
                          {8, 10, 1}, {8, 3, 10}, {5, 3, 8}, {5, 2, 3}, {2, 7, 3},
                          {7, 10, 3}, {7, 6, 10}, {7, 11, 6}, {11, 0, 6}, {0, 1, 6},
                          {6, 1, 10}, {9, 0, 11}, {9, 11, 2}, {9, 2, 5}, {7, 2, 11}
                         };



  //create the vertices

  for ( int i = 0; i < 12; i++ )
  {
    createVertex( vdata[ i ][ 0 ] * m_radius , vdata[ i ][ 1 ] * m_radius, vdata[ i ][ 2 ] * m_radius );
  }

  for ( int i = 0; i < 20; i++ )
  {
    vertex_subdivide( getVertex( fdata[ i ][ 2 ] ), getVertex( fdata[ i ][ 1 ] ), getVertex( fdata[ i ][ 0 ] ), lod );
  }

  normalize();


  midpoints.clear();

}

Sphere::~Sphere()
{}

void Sphere::vertex_subdivide( Vertex *v1, Vertex *v2, Vertex *v3, int depth )
{
  if ( depth == 1 )
  {
    createFace( v1 -> getParentIndex(), v2 -> getParentIndex(), v3 -> getParentIndex() );
    return ;
  }

  Midpoint mp1 = findMidpoint( v1, v2 );
  Midpoint mp2 = findMidpoint( v2, v3 );
  Midpoint mp3 = findMidpoint( v3, v1 );

  vertex_subdivide( v1, mp1.m, mp3.m, depth - 1 );
  vertex_subdivide( v2, mp2.m, mp1.m, depth - 1 );
  vertex_subdivide( v3, mp3.m, mp2.m, depth - 1 );
  vertex_subdivide( mp1.m, mp2.m, mp3.m, depth - 1 );


}


Midpoint Sphere::findMidpoint( Vertex *v1, Vertex *v2 )
{

  Midpoint mp;

  mp.v1 = v1;
  mp.v2 = v2;
  mp.m = 0;

  list < Midpoint > ::iterator it = std::find( midpoints.begin(), midpoints.end(), mp );

  if ( it == midpoints.end() )
  {
    Vector4 p12;

    p12 = ( v1->getPosition() + v2->getPosition() );

    p12 *= .5;
    p12.normalize();
    p12 *= m_radius;

    Vertex *v12 = createVertex( p12 );

    mp.m = v12;
    midpoints.insert( midpoints.end(), mp );
    return mp;
  }

  else
  {
    return *it;
  }
}





















