/***************************************************************************
                       plane.cpp  -  description
                          -------------------
 begin                : Fri Mar 31 2000
 copyright            : (C) 2000 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "plane.h"
#include "vertex.h"
#include "face.h"

#include <iostream>


/** Creates a plane on the XZ plane.
  * it will default to XZ if they aren't.
  * hx, hz, are number of subdivisions each way.
  */

Plane::Plane( float x, float y, float z, float hx, float hz ) : Mesh( x, y, z )
{
  float u;
  float v;

  u = ( hx ) / 2;
  v = ( hz ) / 2;
  int nu = ( int ) hx + 1;
  int nv = ( int ) hz + 1;

  int vx[ 32 ][ 32 ];

  int n = 0;

  int ix = 0;
  int iy = 0;

  for ( float i = -u; i < u + 1; i++ )
  {
    for ( float j = -v; j < v + 1; j++ )
    {
      Vertex *nv = createVertex( i, 0, j );
      cerr << "creating vertex : " << n << ":" << ix << "," << iy << endl;
      n++;
      vx[ ix ][ iy ] = nv -> getParentIndex();
      iy++;
    }

    iy = 0;
    ix++;
  }



  n = 0;
  cerr << nu << "," << nv << endl;

  for ( int i = 0; i < nu - 1; i++ )
  {
    for ( int j = 0; j < nv - 1; j++ )
    {
      cerr << "creating face :" << n << endl;
      int v1 = i * nu + j;
      int v2 = v1 + 1;
      int v3 = ( i + 1 ) * nu + j + 1;
      int v4 = v3 - 1;
      cerr << v1 << "," << v2 << "," << v3 << "," << v4 << endl;
      createFace( vx[ i + 1 ][ j ], vx[ i ][ j ],
                  vx[ i ][ j + 1 ], vx[ i + 1 ][ j + 1 ] );

      n++;
    }

  }

}

Plane::~Plane()
{}




