/***************************************************************************
                         materialparser.cpp  -  description
                            -------------------
   begin                : Sat Jun 8 2002
   copyright            : (C) 2002 by janders
   email                : janders@damascus.onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "materialparser.h"
#include "texturematerial.h"
#include "entity.h"
#include "mesh.h"

#include "stdio.h"



MaterialParser::MaterialParser()
{
  //make sure it's loaded!
  TextureMaterial * m = new TextureMaterial();
  printf( "%d, %d\n", TextureMaterial::TYPE, Mesh::TYPE );
}

MaterialParser::~MaterialParser()
{
}

void MaterialParser::write( QDomElement &parent, Typed *t )
{
  TextureMaterial * m = ( TextureMaterial * ) t ;
  QDomDocument doc = parent.ownerDocument();

  QDomElement material;
  QDomElement e;

  material = doc.createElement( "material" );
  material.setAttribute( "name", m -> name.c_str() );
  material.setAttribute( "id", Parser::getUID() );
  parent.appendChild( material );

  e = doc.createElement( "ambient" );
  e.setAttribute( "r", m -> cAmbient.r );
  e.setAttribute( "g", m -> cAmbient.g );
  e.setAttribute( "b", m -> cAmbient.b );
  material.appendChild( e );

  e = doc.createElement( "diffuse" );
  e.setAttribute( "r", m -> cDiffuse.r );
  e.setAttribute( "g", m -> cDiffuse.g );
  e.setAttribute( "b", m -> cDiffuse.b );
  material.appendChild( e );

  e = doc.createElement( "emissive" );
  e.setAttribute( "r", m -> cEmission.r );
  e.setAttribute( "g", m -> cEmission.g );
  e.setAttribute( "b", m -> cEmission.b );
  material.appendChild( e );

  e = doc.createElement( "specular" );
  e.setAttribute( "r", m -> cSpecular.r );
  e.setAttribute( "g", m -> cSpecular.g );
  e.setAttribute( "b", m -> cSpecular.b );
  material.appendChild( e );


  e = doc.createElement( "shininess" );
  e.setAttribute( "val", m -> shininess );
  material.appendChild( e );

  e = doc.createElement( "opacity" );
  e.setAttribute( "val", m -> alpha );
  material.appendChild( e );

  if ( m -> texture != 0 )
  {
    e = doc.createElement( "color_map" );
    e.setAttribute( "file", m -> texture -> getFilename() -> ascii() );
    material.appendChild( e );
  }

  if ( m -> opacity != 0 )
  {
    e = doc.createElement( "opacity_map" );
    e.setAttribute( "file", m -> opacity -> getFilename() -> ascii() );
    material.appendChild( e );
  }

  if ( m -> specularity != 0 )
  {
    e = doc.createElement( "specularity_map" );
    e.setAttribute( "file", m -> specularity -> getFilename() -> ascii() );
    material.appendChild( e );
  }

  if ( m -> displacement != 0 )
  {
    e = doc.createElement( "displacement_map" );
    e.setAttribute( "file", m -> displacement -> getFilename() -> ascii() );
    material.appendChild( e );
  }

}

Typed * MaterialParser::read( QDomElement &element )
{
  QDomElement e;
  QDomAttr a;

  TextureMaterial *tm = new TextureMaterial();
  tm -> name = element.attributeNode( "name" ).value();

  e = element.namedItem( "diffuse" ).toElement();
  tm -> cDiffuse.r = atoi( e.attributeNode( "r" ).value() );
  tm -> cDiffuse.g = atoi( e.attributeNode( "g" ).value() );
  tm -> cDiffuse.b = atoi( e.attributeNode( "b" ).value() );

  e = element.namedItem( "ambient" ).toElement();
  tm -> cAmbient.r = atoi( e.attributeNode( "r" ).value() );
  tm -> cAmbient.g = atoi( e.attributeNode( "g" ).value() );
  tm -> cAmbient.b = atoi( e.attributeNode( "b" ).value() );

  e = element.namedItem( "specular" ).toElement();
  tm -> cSpecular.r = atoi( e.attributeNode( "r" ).value() );
  tm -> cSpecular.g = atoi( e.attributeNode( "g" ).value() );
  tm -> cSpecular.b = atoi( e.attributeNode( "b" ).value() );

  e = element.namedItem( "emissive" ).toElement();
  tm -> cEmission.r = atoi( e.attributeNode( "r" ).value() );
  tm -> cEmission.g = atoi( e.attributeNode( "g" ).value() );
  tm -> cEmission.b = atoi( e.attributeNode( "b" ).value() );

  e = element.namedItem( "shininess" ).toElement();
  tm -> shininess = atoi( e.attributeNode( "val" ).value() );

  e = element.namedItem( "opacity" ).toElement();
  tm -> alpha = atoi( e.attributeNode( "val" ).value() );

  e = element.namedItem( "color_map" ).toElement();

  if ( ! e.isNull() )
  {
    tm -> texture = new Texture( e.attributeNode( "file" ).value().ascii(), -1 );
  }

  e = element.namedItem( "opacity_map" ).toElement();

  if ( ! e.isNull() )
  {
    tm -> opacity = new Texture( e.attributeNode( "file" ).value().ascii(), -1 );
  }

  e = element.namedItem( "specularity_map" ).toElement();

  if ( ! e.isNull() )
  {
    tm -> specularity = new Texture( e.attributeNode( "file" ).value().ascii(), -1 );
  }

  e = element.namedItem( "displacement_map" ).toElement();

  if ( ! e.isNull() )
  {
    tm -> displacement = new Texture( e.attributeNode( "file" ).value().ascii(), -1 );
  }

  return tm;
}
