/***************************************************************************
                        material.h  -  description
                           -------------------                        
  begin                : Wed Mar 10 1999                      
  copyright            : (C) 1999 by Jon Anderson                         
  email                : ande1514@tc.umn.edu                  
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MATERIAL_H
#define MATERIAL_H
#include "qimage.h"
#include "qpixmap.h"
#include <iostream>
#include "qcolor.h"
#include <stdlib.h>


/**A Material is a set of color properties.  These can be displayed via a
 * pixmap, or applied to geometry.
 *
 *@author Jon Anderson
 */

class Material
{

public:
   /**Construct a default material.*/
   Material( float _r = .5, float _g = .5, float _b = .5, int _ID = -1 );
   ~Material();

   void setRGB( float _r, float _g, float _b );
   int getID()
   {
      return ID;
   };

   int ID;

   float r, g, b, a;

   QPixmap *pixmap;
};

#endif

























