/***************************************************************************
                        marchingcube.h  -  description                              
                           -------------------                                         
  begin                : Tue Nov 16 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MARCHINGCUBE_H
#define MARCHINGCUBE_H

#include "surfaceconstructor.h"

/**This class contains the logic to create a surface using the
marching cube algorithm.
  *@author Jon Anderson
  */

class MarchingCube : public SurfaceConstructor
{

public:
   MarchingCube( QList<IsoSurface> *list );
   ~MarchingCube();
   int polygonise( GRIDCELL grid, double isolevel, TRIANGLE *triangles );
   XYZ VertexInterp( double isolevel, XYZ p1, XYZ p2, double valp1, double valp2 );
   Object *getSurface( float );
   GRIDCELL getGridCell( float x, float y, float z, float step );
   float getSumOfFields( float x, float y, float z );
};

#endif
