/***************************************************************************
                       keyframe.cpp  -  description                        
                          -------------------                              
 begin                : Sun Apr 25 1999                                    
 copyright            : (C) 1999 by Jonathan E. Anderson                   
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "keyframe.h"

Keyframe::Keyframe( int _time ) :
    m_channels()
{
  m_time = _time;
}

Keyframe::~Keyframe()
{
  ChannelMap::iterator it = m_channels.begin();

  while ( it != m_channels.end() )
  {
    Channel * c = it -> second;
    delete c;
    ++it;
  }

}

void Keyframe::save()
{}

void Keyframe::open()
{}

void Keyframe::addChannel( int channel_type, Channel *c )
{
  m_channels.insert( ChannelPair( channel_type, c ) );
}

Channel * Keyframe::getChannel( int channel_type )
{
  return m_channels[ channel_type ];
}

void Keyframe::interpolate( float pct, Keyframe *r, Keyframe *dst )
{
  int new_time;

  new_time = m_time + ( int ) ( ( float ) ( r->getTime() - m_time ) * pct );

  dst -> setTime( new_time );

  ChannelMap::iterator it1 = r->m_channels.begin();
  ChannelMap::iterator it2 = m_channels.begin();

  while ( it1 != r->m_channels.end() &&
          it2 != m_channels.end() )
  {

    int channel_type = it1 -> first;
    Channel * c1 = it1 -> second;
    Channel * c2 = it2 -> second;
    Channel *nc = c1 -> clone();

    c1 -> interpolate( pct, c2, nc );
    dst -> addChannel( channel_type, nc );

    ++it1;
    ++it2;
  }
}

bool Keyframe::operator ==( Keyframe &s )
{
  return ( m_time == s.m_time );
}

bool Keyframe::operator <=( Keyframe &s )
{
  return ( m_time <= s.m_time );
}

bool Keyframe::operator <( Keyframe &s )
{
  return ( m_time < s.m_time );
}



Keyframe & Keyframe::operator=( Keyframe &s )
{
  copy( s );
  return *this;
}

void Keyframe::copy( Keyframe &s )
{
  // Need to clear each property.
  ChannelMap::iterator it = s.channelsBegin();

  while ( it != s.channelsEnd() )
  {
    int channel_type = it -> first;
    Channel * c = it -> second -> clone();
    m_channels.insert( ChannelPair( channel_type, c ) );
    ++it;
  }

  m_time = s.m_time;

}













