/***************************************************************************
                        channels.h  -  description
                           -------------------                                         
  begin                : Sun Jan 27, 2002
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janders@users.sf.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef CHANNELS_H
#define CHANNELS_H

#include <Math/vector4.h>
#include <Math/quat.h>

class Channel
{

public:
   Channel()
   {}

   ;

   Channel & operator=( const Channel &c )
   { return *this;
    }

   ;
   virtual void interpolate( float pct, Channel *, Channel * ) = 0;
   virtual Channel * clone() = 0;
};

class VectorChannel : public Channel
{

public:
   VectorChannel( const Vector4 &p ) : Channel()
   {
      value = p;
   };

   VectorChannel & operator=( const VectorChannel &c )
   {
      value = c.value;
      return *this;
   };

   Vector4 value;
   Channel * clone()
   {
      VectorChannel * c = new VectorChannel( value );
      return c;
   };

   void interpolate( float pct, Channel *r, Channel *dst )
   {
      VectorChannel * dest = dynamic_cast<VectorChannel*>( dst );
      VectorChannel *rhs = dynamic_cast<VectorChannel*>( r );

      dest->value.x = value.x * pct + rhs->value.x * ( 1 - pct );
      dest->value.y = value.y * pct + rhs->value.y * ( 1 - pct );
      dest->value.z = value.z * pct + rhs->value.z * ( 1 - pct );
      dest->value.w = value.w * pct + rhs->value.w * ( 1 - pct );
   }

};

class QuatChannel : public Channel
{

public:
   QuatChannel( const Quat &p ) : Channel( )
   {
      value = p;
   };

   QuatChannel & operator=( const QuatChannel &c )
   {
      value = c.value;
      return *this;
   };

   Channel * clone()
   {
      QuatChannel * c = new QuatChannel( value );
      return c;
   };

   Quat value;
   void interpolate( float pct, Channel *r, Channel *dst )
   {
      QuatChannel * dest = dynamic_cast<QuatChannel*>( dst );
      QuatChannel *rhs = dynamic_cast<QuatChannel*>( r );
      dest->value = Interpolate( value, rhs->value, pct );
   }

};

class IntChannel : public Channel
{

public:
   IntChannel( const int &p ) : Channel( )
   {
      value = p;
   };

   IntChannel & operator=( const IntChannel &c )
   {
      value = c.value;
      return *this;
   };

   Channel * clone()
   {
      IntChannel * c = new IntChannel( value );
      return c;
   };

   int value;
   void interpolate( float pct, Channel *r, Channel *dst )
   {
      IntChannel * dest = dynamic_cast<IntChannel*>( dst );
      IntChannel *rhs = dynamic_cast<IntChannel*>( r );

      dest->value = ( int ) ( ( float ) value * pct + ( float ) rhs->value * ( 1 - pct ) );
   }

};

class FloatChannel : public Channel
{

public:
   FloatChannel( const float &p ) : Channel( )
   {
      value = p;
   };

   FloatChannel & operator=( const FloatChannel &c )
   {
      value = c.value;
      return *this;
   };

   Channel * clone()
   {
      FloatChannel * c = new FloatChannel( value );
      return c;
   };

   float value;
   void interpolate( float pct, Channel *r, Channel *dst )
   {
      FloatChannel * dest = dynamic_cast<FloatChannel*>( dst );
      FloatChannel *rhs = dynamic_cast<FloatChannel*>( r );
      dest->value = value * pct + rhs->value * ( 1 - pct );
   }

};

#endif


