<?php
/*
 * $Horde: imp/search.php,v 2.71.2.11 2005/01/03 11:25:49 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';


IMP::checkAuthentication(OP_HALFOPEN);

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$title = _("Message Search");
$js_onLoad = null;

require IMP_TEMPLATES . '/common-header.inc';
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

$newcol = 1;
$numcolumns = 1;
$search_folders = '';
$mailboxes = IMP::flist();
$total = ceil(count($mailboxes) / 3);

foreach ($mailboxes as $mbox) {
    if (array_key_exists('val', $mbox) && !empty($mbox['val'])) {
        $newcol++;
        $search_folders .= '<input type="checkbox" name="search_folders[]" ';
        $search_folders .= 'value="' . $mbox['val'] . '"';
        if ($mbox['label'] == 'INBOX') {
            $search_folders .= ' checked="checked"';
        }
        $search_folders .= ' />' . str_replace(' ', '&nbsp;', htmlspecialchars($mbox['label'])) . "<br />\n";

        if (($newcol > $total) && ($numcolumns != 3)) {
            $newcol = 1;
            $numcolumns++;
            $search_folders .= "</td>\n";
            $search_folders .= '<td class="control" valign="top" align="left">';
        }
    }
}

/* Build the months array. */
$months = array('1'   =>  _("January"),
                '2'   =>  _("February"),
                '3'   =>  _("March"),
                '4'   =>  _("April"),
                '5'   =>  _("May"),
                '6'   =>  _("June"),
                '7'   =>  _("July"),
                '8'   =>  _("August"),
                '9'   =>  _("September"),
                '10'  =>  _("October"),
                '11'  =>  _("November"),
                '12'  =>  _("December"));

require IMP_TEMPLATES . '/search/javascript.inc';
require IMP_TEMPLATES . '/search/main.inc';

$registry->shutdown();

require IMP_TEMPLATES . '/common-footer.inc';

?>
