#!/usr/bin/env python

#############################[ Parameters you should change if install failed ]#########################################
# qtdir should point to the directory where QT is installed. (Inside this dir you should have a lib and include dir)
qtdir=["/usr/share/qt3/"]      # ["/usr/qt/3/"] if you have a Gentoo system

# python_dir should point to the directory where Python header files may be found.. (Inside this dir you should have a Python.h)
python_dir="/usr/include/python"

# QT library to use. If qt-mt is not found, you may need to change it to "qt"
qtlibraries = ["qt-mt",  # you may want to try "qt" if your QT has no multithreading support
               "jpeg",   # libjpeg is required as of imgSeek 0.8.5
               ]

#############################[ End of parameters that can be changed ]##################################################

try:
    import sys,commands,traceback,os
    from distutils import sysconfig
    from distutils.core import setup,Extension
    from distutils.command.build_ext import build_ext
    from distutils.errors import CCompilerError
    from string import *
except:
    traceback.print_exc()
    print "Unable to import python distutils."
    print "You may want to install the python-dev package on your distribution."
    sys.exit(1)
try:
    import imgSeekLib
except:
    print "Unable to load imgSeekLib module. Run \"python setup.py install\" from the root imgSeek distribution dir."
    sys.exit(1)

print "#################################### Check for PyQT"
try:
    import qt
except:
    print """Could not import the PyQt library. Please install it.
The source for PyQt can be found at: http://www.riverbankcomputing.co.uk. You should first try installing it from your distribution package system. (PyQT package)"""
    sys.exit(1)

print "PyQt is installed"

############## Init some vars
extra_compile_args=["-O3"]
extra_link_args=[]
include_dirs = []
library_dirs = []
libraries = []
imgSeekLib.failedbuild=0

if int(qt.QT_VERSION_STR[0]) < 3:
    print """imgSeek does not work with a Qt library with a version < 3.0.0
Please upgrade your Qt library. The source for Qt can be found at:
http://www.trolltech.com
You should first try installing it from your distribution package system. (QT package)
"""
else:
    print "Qt is recent enough: "+str(qt.QT_VERSION_STR)
    include_dirs.append("/usr/include/qt3")
    library_dirs.append("/usr/lib/qt3")
    library_dirs.append("/usr/lib/")

print "#################################### Check QT"

gqtdir=None
try:                                    # guess QT dir:
    gqtdir = os.environ["QTDIR"]
except:
    print \
"""- WARNING ---
Unable to guess QT directory from the QTDIR environment variable.
Set it to your Qt directory. E.g:
\"export QTDIR=/usr/lib/qt3\"

If even after that install fails, please open \"setup.py\" and edit the \"qtdir\" variable (on the beginning of the file) with the correct location where QT was installed.
You may ignore this warning if you have ImageMagick and it's development files and the module compilation succeded.
"""
if gqtdir:                              # more checks
    if gqtdir[-1] != os.sep: gqtdir=gqtdir+os.sep
    if gqtdir not in qtdir: qtdir.append(gqtdir)

for qdir in qtdir:
    include_dirs.append(qdir+"include")
    library_dirs.append(qdir+"lib")
hasQT=0

for dir in include_dirs:
    if dir[-1] != os.sep: dir=dir+os.sep
    if os.path.exists(dir+"qimage.h"): hasQT=1
if not hasQT:
    print "--- WARNING ---\nUnable to find QT development files on the specified QTDIR. imgSeek will try to use ImageMagick..."
    include_dirs=[]
    library_dirs=[]
else:
    libraries=qtlibraries
print "Checked."

print "#################################### Check Python"
if int(sys.version[0]) < 2:             # check py version and Python include dir
    print "--- WARNING ---\nYou need Python version 2.x or more. If something doesn't work or install fails, please update Python."
if python_dir[-1] != os.sep: python_dir=python_dir+os.sep
if not os.path.exists(python_dir+"Python.h"):
    python_dir=sysconfig.get_python_inc() # get help from distutils sysconfig submodule
    if python_dir[-1] != os.sep: python_dir=python_dir+os.sep
    if not os.path.exists(python_dir+"Python.h"): # give up...
        print "--- WARNING ---\nUnable to find python development files. Make sure you have the python-devel package for your GNU/Linux distribution installed."
        print "If that didn't help, you may need to locate the place where the python C headers are stored and change the line in setup.py where \"/usr/include/python2.3\" is found. (on the beginning of setup.py)"
include_dirs.append(python_dir)
print "Checked."

hasIMagick=0

if not hasQT:                           # Qt support is now faster than ImageMagick, so use Qt as default
    print "#################################### Check ImageMagick"
    try:
        fnd=0
        pathvar=os.environ["PATH"]
        for pv in split(pathvar,':'):
            if os.path.exists(pv+'/Magick++-config') or os.path.exists(pv+'Magick++-config'):
                fnd=1
        if fnd:
            IMagCFlag=os.popen("Magick++-config --cxxflags --cppflags").read()
            if find(IMagCFlag,"-I") != -1:
                IMagCFlag=replace(IMagCFlag,"\n"," ")
                IMagCFlag=split(IMagCFlag,' ')
                IMagCLib=os.popen("Magick++-config --ldflags --libs").read()
                IMagCLib=replace(IMagCLib,"\n"," ")
                IMagCLib=split(IMagCLib,' ')
                hasIMagick=1
        else:
            print "--- WARNING ---\nUnable to find Magick++-config. Are you sure you have ImageMagick and it's development files installed correctly ?\nIgnore this warning if QT development files were previously detected."
    except:
        traceback.print_exc()
        print "Please report the above traceback to \"nieder@mail.ru\""
    if hasIMagick:
        extra_compile_args=extra_compile_args+["-DImMagick"]
        libraries=[]                        # remove all other libraries and only use ImageMAgick
        for cf in IMagCFlag:
            cf=strip(cf)
            if not cf: continue
            extra_compile_args.append(cf)
        for cf in IMagCLib:
            cf=strip(cf)
            if not cf: continue
            extra_link_args.append(cf)
        print "Found the following arguments:"
        print "extra_compile_args",extra_compile_args
        print "extra_link_args",extra_link_args
    else:
        print "ImageMagick library and development files not found."
if not hasIMagick and not hasQT:
    print "--- ERROR ---\nUnable to find QT development files and ImageMagick. Make sure you have development support for at least one of these and then run setup again.\nsetup will continue, but imgSeek may not work."
print "Checked."

if hasQT:    print "Using QT ..."
if hasIMagick:    print "Using ImageMagick ..."

class fallible_build_ext(build_ext):
    """the purpose of this class is to know when a compile error ocurred """
    def run(self):
        try:
            build_ext.run(self)
        except CCompilerError:
            traceback.print_exc()
            imgSeekLib.failedbuild=1
            print """
Unable to compile and install the C++ extension module.
It is strongly recommended that you install the python-dev (python-devel on some distributions) package for your GNU/Linux distribution, and then try \"python setup.py install\" again.
Please refer to http://imgseek.sf.net/requirements.html for more instructions.
"""
try:
    print "#################################### Installing"
    setup(name="imgSeek",
          version=imgSeekLib.__version__,
          description="imgSeek photo collection manager and viewer with content-based query.",
          long_description ="""imgSeek is a photo collection manager and viewer with content-based search and many other features. The query is expressed either as a rough sketch painted by the user or as another image you supply (or an image in your collection).""",
          author="Ricardo Niederberger Cabral",
          author_email="nieder|at|mail.ru",
          url="http://imgseek.sourceforge.net/",
          platforms = ['Linux'],
          cmdclass = { 'build_ext': fallible_build_ext},
          license = 'GPL2',
          data_files = [("share/imgSeek",["imgSeekLib/color.png",
                                       # PIL Fonts
                                       "imgSeekLib/courB12.pil",
                                       "imgSeekLib/courB12.pbm",
                                       # translations
                                       "imgSeekLib/imgseek_pt_BR.qm",
                                       ]),
            # HTML Styles
            ('share/imgSeek/styles/Acqua',[
                           'imgSeekLib/styles/Acqua/style.css',
                           'imgSeekLib/styles/Acqua/bg.png',
                           'imgSeekLib/styles/Acqua/coininfd.png',
                           'imgSeekLib/styles/Acqua/coininfg.png',
                           'imgSeekLib/styles/Acqua/coinsupd.png',
                           'imgSeekLib/styles/Acqua/uparrow.png',
                           'imgSeekLib/styles/Acqua/left.png',
                           'imgSeekLib/styles/Acqua/right.png',
                           'imgSeekLib/styles/Acqua/coinsupg.png',
                           'imgSeekLib/styles/Acqua/d.png',
                           'imgSeekLib/styles/Acqua/fond.png',
                           'imgSeekLib/styles/Acqua/g.png',
                           'imgSeekLib/styles/Acqua/inf.png',
                           'imgSeekLib/styles/Acqua/space15.png',
                           'imgSeekLib/styles/Acqua/sup.png']),
            ('share/imgSeek/styles/Slides',[
                           'imgSeekLib/styles/Slides/style.css',
                           'imgSeekLib/styles/Slides/bg.png',
                           'imgSeekLib/styles/Slides/coininfd.png',
                           'imgSeekLib/styles/Slides/coininfg.png',
                           'imgSeekLib/styles/Slides/coinsupd.png',
                           'imgSeekLib/styles/Slides/uparrow.png',
                           'imgSeekLib/styles/Slides/left.png',
                           'imgSeekLib/styles/Slides/right.png',
                           'imgSeekLib/styles/Slides/coinsupg.png',
                           'imgSeekLib/styles/Slides/d.png',
                           'imgSeekLib/styles/Slides/fond.png',
                           'imgSeekLib/styles/Slides/g.png',
                           'imgSeekLib/styles/Slides/inf.png',
                           'imgSeekLib/styles/Slides/space15.png',
                           'imgSeekLib/styles/Slides/sup.png'])],
          packages=['imgSeekLib'],
          scripts= ['imgSeek','Tools/imgSeekCmd'],
          ext_modules = [
            Extension("imgSeekLib.imgdb",["imgSeekLib/imgdb.cpp",
                                          "imgSeekLib/haar.cpp",
                                          "imgSeekLib/jpegloader.cpp",
                                          ],
                      include_dirs = include_dirs,
                      library_dirs = library_dirs,
                      extra_compile_args=extra_compile_args,
                      extra_link_args=extra_link_args,
                      libraries = libraries
                     )]
         )

except:
    traceback.print_exc()
    print "An unexpected error occurred during setup.\nPlease help development by reporting this bug to \"imgseek-devel@lists.sourceforge.net\"."
    print "You have to become root before installing imgSeek. (type \"su\" and then enter your root password)"

if imgSeekLib.failedbuild:
      print """Warning:\n
Unable to compile and install the C++ module extension.
It is strongly recommended that you install the python-dev (python-devel on some distributions) package for your GNU/Linux distribution, and then try \"python setup.py install\" again.
Also make sure you either have QT development files installed (package qt-3.x-devel on some distributions) or ImageMagick libraries and development files installed. (recommended)
Please refer to http://imgseek.sf.net/requirements.html for more instructions.
"""
else:
    print "\nimgSeek install complete.\nRun it with \"imgSeek\"\n"
