""" Duplicate finder wizard implementation

    begin                : Mon Jan 13 2003
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: DuplicateWiz.py,v 1.54 2004/10/21 02:50:16 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""

from string import *
import traceback
import os.path
try:
    from qt import *
    from DuplicateForm import DuplicateWizard
except:
    traceback.print_exc()
    print "DuplicateWiz: Unable to import some imgSeek modules. Some features will not work."

class DuplicateWiz(DuplicateWizard):
    def tr(self,msg):
        return qApp.translate('main',msg)
    
    def __init__(self, parent,env):
        DuplicateWizard.__init__(self,parent)
        self.env = env
        self.curBatch = -1
        self.setFinishEnabled(self.lastpage,1)
        self.helpButton().hide()        # show help for this wizard. Until it's not done, just hide the button
        self.cancelled = 0
        self.curdb = self.env.curdb
        try:
            self.bid = self.curdb.batches.keys()[0]
        except:
            traceback.print_exc()
            pass
        self.curdb.cbs["Batch"].append(self.updateDirList)

    def showEvent(self,e):
        self.updateDirList()

    def updateDirList(self,what = None):
        """call it to sync curdb batch list to what the ui shows """
        self.batchcombo.clear()
        for bid in self.curdb.batches.keys():
            self.batchcombo.insertItem(self.curdb.batches[bid][0])
        if self.bid != -1:
            self.showBatch(self.bid)
        else:
            if len(self.curdb.batches.keys()):
                self.showBatch(self.curdb.batches.keys()[0])
            else:
                self.htmlsourcelistbox.clear()

    def showBatch(self,bid):
        txt = self.curdb.BatchToText(bid)
        self.htmlsourcelistbox.clear()
        self.bid = bid
        if not txt:
            self.htmlsourcelistbox.insertItem(self.tr("You should populate this batch with groups/volumes/directories before using it to find duplicates. Right-click on a directory or volume and select \"Add to batch\""))
            return
        for it in txt:
            self.htmlsourcelistbox.insertItem(it[1]+" - "+it[0])

    def accept(self):
        DuplicateWizard.accept(self)

    def reject(self):
        DuplicateWizard.reject(self)

    def DuplicateWizard_helpClicked(self):
        pass

    def DuplicateWizard_selected(self,a0):
        if str(a0)==str(self.tr("Duplicates")):
            self.run()

    def removefilebtn_clicked(self):
        it = self.reslist.firstChild()
        dragids = []
        dragits = []
        while it:
            if self.reslist.isSelected(it):
                dragids.append(it.id)
                dragits.append(it)
            it = it.itemBelow()
        if not dragids:
            return
        res = QMessageBox.information( self, "imgSeek",str(self.tr("Are you sure you want to physically remove the %d selected file(s) ?"))%len(dragids),   QString(self.tr("&Delete")), QString(self.tr("Cancel")))
        if res: return
        self.curdb.doNotSave = 1
        deletedOK = []                  # list of id's deleted succesfully
        for id in dragids:
            try:
                os.remove(self.curdb.img[id][0])
                deletedOK.append(id)
            except:
                traceback.print_exc()
                self.parent().msgerror(self.tr("Error deleting file."))

            self.curdb.removeFile(id)
        self.curdb.doNotSave = 0
        if len(dragids):
            self.curdb.changedDB({"scope":"Img","reason":"removed","subjects":dragids})
        for it in dragits:
            if it.id not in deletedOK: continue
            it.setPixmap(0,QPixmap())
            it.setText(0,self.tr("DELETED"))

    def avglumcompcheck_toggled(self,a0):
        self.avglthresedit.setEnabled(a0)

    def contentbased_toggled(self,a0):
        self.simthresdedit.setEnabled(a0)

    def batchedbtn_clicked(self):
        self.env.wnd.editcategaction_activated()

    def batchcombo_activated(self,a0):
        try:
            bid = self.curdb.batches.keys()[a0]
        except:
            print "key Error showing desired batch"
            return
        self.showBatch(bid)

    def stopdupbtn_clicked(self):
        self.cancelled = 1

    def reslist_doubleClicked(self,a0):
        try:
            from SlideShowDialog import SlideShowDialog
            ds = SlideShowDialog(self,self.env)
            ds.showImg(self.curdb.img[a0.id][0])
        except:
            pass

    def run(self):
        donetext = self.tr("Search done.\nDouble-click image to show full size.\nSelect those you wish to physically remove and click on the trash button.")
        aborttext = self.tr("Search aborted.\nDouble-click image to show full size.\nSelect those you wish to physically remove and click on the trash button.")
        worktext = self.tr("Searching for duplicates, please wait...\nDouble-click image to show full size.\nSelect those you wish to physically remove and click on the trash button.")
        self.resultLabel.setText(worktext)
        self.env.app.processEvents()
        self.cancelled = 0
        doavgl = 0
        dofullsim = 0
        dodim = None
        dothumb = 0
        dofsize = 0
        dofname = 0
        thumb = 0
        igncommondim = 0
        defaultlumthres = 0.001
        defaultsimthres = 90
        commondims = ["640 x 480","320 x 200","800 x 600","1024 x 768","1280 x 1024","1600 x 1200","1152 x 864","128 x 128"]
        lumthres = defaultlumthres
        simthres = defaultsimthres
        if self.avglumcompcheck.isChecked():            doavgl = 1
        if self.imgdim.isChecked():            dodim = 1
        if self.filesz.isChecked():            dofsize = 1
        if self.filename.isChecked():            dofname = 1
        if self.contentbased.isChecked():            dofullsim = 1
        if self.showthumbresultcheck.isChecked():            dothumb = 1
        if self.igncommondim.isChecked():            igncommondim = 1
        if doavgl:
            try:
                lumthres = float(str(self.avglthresedit.text()))
            except:
                traceback.print_exc()
                print "Error getting average luminance threshold, using the 0.001 default"
            if lumthres>defaultlumthres:
                #QMessageBox.information( None, "imgSeek","The supplied threshold is too big. Enter one lower than "+str(defaultlumthres))
                pass
                #return
        if dofullsim:
            try:
                simthres = float(str(self.simthresdedit.text()))
            except:
                traceback.print_exc()
                print "Error getting average luminance threshold, using the 0.001 default"
            if simthres>defaultsimthres:
                #QMessageBox.information( None, "imgSeek","The supplied threshold is too big. Enter one lower than "+str(defaultlumthres))
                pass
                #return
        self.reslist.clear()
        found = []
        targetlist = []
        self.curdb.crawlBatchForImg(self.bid,targetlist)
        if not len(targetlist):
            QMessageBox.information( None, "imgSeek",self.tr("You didn't select any Work Batch, or the one selected contains no image. Unable to continue. Choose a batch with images and try again."))
            return
        for id in targetlist:
            self.env.app.processEvents()
            if self.cancelled:
                self.resultLabel.setText(aborttext)
                return
            if id in found:continue     # skip imgs that have already been detected as a dup
            avgl = None
            fullsim = 0
            dim = None
            fsize = None
            fname = None
            if dodim:
                try:
                    dim = self.curdb.meta[id]["Dimensions"]
                except:                 # unable to retrieve dimension. Should I try to determine it now by another mean ?
                    dim = None
            if dofsize:
                try:
                    fsize = self.curdb.meta[id]["Filesize"]
                except:                 #TODO5: retrieve it with os.stat
                    fsize = None
            if dofname:
                try:
                    fname = self.curdb.meta[id]["Filename"]
                except:
                    try:
                        fname = os.path.split(self.curdb.img[id][0])[-1]
                    except:
                        fname = None
            others = targetlist[:]
            try:                        #TODO: this is probably ineficient as hell
                others.remove(id)           # so id is not found as a duplicate to id
            except:
                traceback.print_exc()
                print "Error generating list of target images."
            rest = []
            for cid in others:
                if id==cid:
                    print "Duplicate image id found on volume."
                    continue
                if not self.curdb.img.has_key(cid): continue
                if cid in found: continue
                res = []                  # the reasons why this cid was detected as  a dup
                if doavgl:
                    if self.curdb.imgdb.calcAvglDiff(cid,id) < lumthres:
                        res.append(self.tr("Average color match"))
                        found.append(cid)
                if dofname:
                    try:
                        f1 = lower(self.curdb.meta[id]["Filename"])
                        f2 = lower(self.curdb.meta[cid]["Filename"])
                        if find(f1,f2)!= -1  or find(f2,f1) != -1:
                            res.append(self.tr("Filename match"))
                            found.append(cid)
                    except:
                        traceback.print_exc()
                if dofsize:
                    if self.curdb.meta[id]["Filesize"]==self.curdb.meta[cid]["Filesize"]:
                        res.append(self.tr("Filesize match "))
                        found.append(cid)
                if dofullsim:
                    diff = self.curdb.imgdb.calcDiff(id,cid)
                    if (-1*diff *100.0/300.0 )> simthres:
                        res.append(self.tr("Content match"))
                        found.append(cid)
                if dodim:
                    if (self.curdb.meta[id]["Dimensions"]==self.curdb.meta[cid]["Dimensions"])\
                    and self.curdb.meta[id]["Dimensions"]\
                    and self.curdb.meta[id]["Dimensions"]!="None":
                        if (igncommondim and self.curdb.meta[id]["Dimensions"] not in commondims) or (not igncommondim):
                            res.append(str(self.tr("Dimensions match: "))+self.curdb.meta[id]["Dimensions"])
                            found.append(cid)
                if res: rest.append([id,cid,res])
            if rest:                    # dups found for this id
                lvi = QListViewItem(self.reslist,self.curdb.meta[id]["Filename"],"",self.curdb.meta[id]["Filesize"],os.path.split(self.curdb.img[id][0])[0])
                lvi.id = id
                lvi.setOpen(1)
                if dothumb:
                    lvi.setPixmap(0,QPixmap(self.curdb.getThumbDB(id)))
                if len(rest) > len(self.curdb.img.keys()): # trim the last 10 results in case something absurd happens
                    rest = rest[:len(self.curdb.img.keys())-10]
                for res in rest:
                    rstx = ""
                    for reason in res[2]:
                        rstx = rstx + str(reason) + "\n"
                    if rstx:rstx = rstx[:-1]
                    lvc = QListViewItem(lvi,self.curdb.meta[res[1]]["Filename"],rstx,self.curdb.meta[res[1]]["Filesize"],os.path.split(self.curdb.img[res[1]][0])[0])
                    lvc.id = res[1]
                    if dothumb:
                        lvc.setPixmap(0,QPixmap(self.curdb.getThumbDB(res[1])))
        if self.beepcheck.isChecked():
            self.env.app.beep()
        self.resultLabel.setText(donetext)
