""" Database callback module

    begin                : 2003-01-26 09:03:06 rnc
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: dbCallbacks.py,v 1.13 2004/03/04 22:20:21 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
# IMPORTANT NOTE: This is the crappiest thing I ever wrote.

### GLOBALS
curdb = None
wnd = None                                # points to MainForm
env = None

### Callbacks

def cbAll(what = None):
    """called whenever there is the slightest modification to db """
    if what and env.verbose: print what
    if what and what.has_key("save") and not what["save"]: return
    if not curdb.doNotSave and int(env.options["database.alwayssave"]):
        if curdb and not curdb.savedb():
            wnd.msgerror("Error saving database file.")

def cbGroup(what):
    wnd.updateGroupList()
    cbAll(what)
    wnd.updateAddTab()

def cbDir(what):
    wnd.updateDirList()
    cbAll(what)

def cbMeta(what):
    wnd.updateDirList()
    cbAll(what)

def cbSimGroup(what):
    wnd.updateCategoryView()
    cbAll(what)

def cbVolume(what):
    wnd.updateDirList()
    wnd.updateAddTab()
    cbAll(what)

def cbDatabase(what):
    if what["reason"]=="reset":
        curdb.doNotSave = 1
        cbGroup(None)
        cbDir(None)
        cbVolume(None)
        cbImg(None)
        cbBatch(None)
        wnd.updateAddTab()
        curdb.doNotSave = 0
        # close dialogs to make sure every data is in sync
        if wnd:
            wnd.updateStatusInfo()
            if wnd.MetaForm:
                wnd.MetaForm.close()
                del wnd.MetaForm
                wnd.MetaForm = None
            if wnd.AlbumForm:
                wnd.MetaForm.close()
            if wnd.BatchMgrFrm:
                wnd.MetaForm.close()
            if wnd.DuplicateForm:
                wnd.MetaForm.close()
            if wnd.ExportForm:
                wnd.MetaForm.close()
            if wnd.ImportForm:
                wnd.MetaForm.close()
            if wnd.TransformForm:
                wnd.MetaForm.close()
    if what["reason"]=="opened":
        curdb.doNotSave = 1
        cbGroup(None)
        cbDir(None)
        cbMeta(None)
        cbSimGroup(None)
        cbVolume(None)
        cbImg(None)
        cbBatch(None)
        if wnd:
            wnd.updateStatusBar(what["subject"]+" opened successfully.")
        wnd.updateAddTab()
        curdb.doNotSave = 0
    if what["reason"]=="saved":
        if wnd:
            wnd.updateStatusBar(what["subject"]+" saved.")

def cbImg(what):
    if not what: return
    if what["reason"]=="viewtransformed": # gui called me because user thinks this image should be displayed in a certain way
        curdb.meta[what["subject"]]["ViewRotate"] = what["transform"]
        return
    cbDir(None)
    cbGroup(None)
    wnd.refreshIconView()

def cbBatch(what):
    pass
