/* $Id: main.m,v 1.5 2003/06/29 17:28:34 probert Exp $ */

#include <AppKit/AppKit.h>

#include "AppController.h"
#include "Defines.h"

#define APP_NAME @"ImageViewer"

/*
 * Create the application's menu
 */

void createMenu();

/*
 * Initialise and go!
 */

int main(int argc, const char *argv[]) 
{
  NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
  AppController     *controller;
  
  [NSApplication sharedApplication];

  createMenu();

  controller = [[AppController alloc] init];
  [NSApp setDelegate:controller];
  
  RELEASE(pool);

  return NSApplicationMain (argc, argv);
}

void createMenu()
{
  NSMenu *menu;
  NSMenu *info;
  NSMenu *images;
  NSMenu *edit;
  NSMenu *services;
  NSMenu *windows;

  SEL action = @selector(method:);

  menu = [[NSMenu alloc] initWithTitle:APP_NAME];

  [menu addItemWithTitle:_(@"Info") action:@selector(showInfoPanel:) keyEquivalent:@""];
  [menu addItemWithTitle:_(@"Images") action:action keyEquivalent:@""];
  [menu addItemWithTitle:_(@"Edit") action:action keyEquivalent:@""];
  [menu addItemWithTitle:_(@"Inspector...") action:@selector(showInspector:) keyEquivalent:@"I"];
  [menu addItemWithTitle:_(@"Windows") action:action keyEquivalent:@""];
  [menu addItemWithTitle:_(@"Services") action:action keyEquivalent:@""];
  [menu addItemWithTitle:_(@"Hide") action:@selector(hide:) keyEquivalent:@"h"];
  [menu addItemWithTitle:_(@"Quit") action:@selector(terminate:) keyEquivalent:@"q"];

  info = AUTORELEASE([[NSMenu alloc] init]);
  [info addItemWithTitle:_(@"Info Panel...") action:@selector(showInfoPanel:) keyEquivalent:@""];
  [info addItemWithTitle:_(@"Preferences") action:@selector(showPrefPanel:) keyEquivalent:@""];
  [info addItemWithTitle:_(@"Help") action:action keyEquivalent:@"?"];
  [menu setSubmenu:info forItem:[menu itemWithTitle:_(@"Info")]];

  images = AUTORELEASE([[NSMenu alloc] init]);
  [images addItemWithTitle:_(@"Open File...") action:@selector(openImage:) keyEquivalent:@"o"];
  [images addItemWithTitle:_(@"Open Path...") action:@selector(openImages:) keyEquivalent:@"O"];
  [menu setSubmenu:images forItem:[menu itemWithTitle:_(@"Images")]];

  edit = AUTORELEASE([[NSMenu alloc] init]);
  [edit addItemWithTitle:_(@"Cut") action:action keyEquivalent:@"x"];
  [edit addItemWithTitle:_(@"Copy") action:action keyEquivalent:@"c"];
  [edit addItemWithTitle:_(@"Paste") action:action keyEquivalent:@"v"];
  [edit addItemWithTitle:_(@"Delete") action:action keyEquivalent:@""];
  [edit addItemWithTitle:_(@"Select All") action:action keyEquivalent:@"a"];
  [menu setSubmenu:edit forItem:[menu itemWithTitle:_(@"Edit")]];

  windows = AUTORELEASE([[NSMenu alloc] init]);
  [windows addItemWithTitle:_(@"Use as window's default size")
	   action:@selector(setDefaultSize:)
	   keyEquivalent:@""];
  [windows addItemWithTitle:_(@"Arrange")
	   action:@selector(arrangeInFront:)
	   keyEquivalent:@""];
  [windows addItemWithTitle:_(@"Miniaturize")
	   action:@selector(performMiniaturize:)
	   keyEquivalent:@"m"];
  [windows addItemWithTitle:_(@"Close")
	   action:@selector(performClose:)
	   keyEquivalent:@"w"];
  [menu setSubmenu:windows forItem:[menu itemWithTitle:_(@"Windows")]];

  [NSApp setWindowsMenu: windows];


  services = AUTORELEASE([[NSMenu alloc] init]);
  [menu setSubmenu:services forItem:[menu itemWithTitle:_(@"Services")]];
    
  [NSApp setMainMenu:menu];
  [NSApp setServicesMenu: services];

}

