#!/usr/bin/env python
import os
import re

from setuptools import setup


if os.path.isfile("MANIFEST"):
    os.unlink("MANIFEST")


VERSION = re.search('__version__ = "([^"]+)"',
                    open("imagestore/__init__.py").read()).group(1)


setup(name="image-store-proxy",
      version = VERSION,
      description = "Image Store Proxy for the Canonical Image Store",
      author = "Gustavo Niemeyer",
      author_email = "gustavo@niemeyer.net",
      license = "GPL",
      long_description =
"""\
The Image Store Proxy sits in the middle of three entities: the
Eucalyptus Image Store UI, the Eucalyptus S3 and EC2 APIs, and
the upstream Canonical Image Store API.
""",
      scripts = ["image-store-proxy"],
      packages = [
          "imagestore",
          "imagestore.tests",
          "imagestore.lib",
          "imagestore.lib.tests",
          ],
      )
