Summary:IIIMF Input Method Software Developpers Kit
Name: im-sdk
Epoch: 1
Version: 11_4
Release: 4
License: GPL
Source: %{name}-%{version}.tar.bz2

%define rcscript IIim

URL: http://www.oepni18n.org/
Group: User Interface/X
Buildroot: %{_tmppath}/%{name}-%{version}-root
BuildPreReq: tcp_wrappers
BuildRequires: Canna-devel

%description
im-sdk is a Software Development kit for
IIIMF(Internet/Intranet Input Method Framework).
IIIMF is a platform neutral/device independent
multi-lingual input method framework.

%package -n iiimf-csconv
Summary:      Codeset Conversion modules for IIIMF components
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on

%description -n iiimf-csconv
Provides Codeset Conversion modules for IIIMF components.

%package -n iiimf-protocol-lib
Summary:      Internet/Intranet Input Method Protocol library
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on

%description -n iiimf-protocol-lib
Provides Internet/Intranet Input Method Protocol library.

%package -n iiimf-protocol-lib-devel
Summary:      Internet/Intranet Input Method Protocol library header files.
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on

%description -n iiimf-protocol-lib-devel
Provides Internet/Intranet Input Method Protocol library header files.

%package -n iiimf-client-lib
Summary:      Internet/Intranet Input Method Client Framework library
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on
Requires:	iiimf-protocol-lib >= 11_4-4

%description -n iiimf-client-lib
Provides Internet/Intranet Input Method Client Framework library.

%package -n iiimf-client-lib-devel
Summary:      Internet/Intranet Input Method Client Framework library header files.
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on

%description -n iiimf-client-lib-devel
Provides Internet/Intranet Input Method Client Framework library header files.

%package -n iiimf-server
Summary:      IIIMF input method server
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on
#Requires:	iiimf-csconv >= 11_4-4
Requires:	iiimf-protocol-lib >= 11_4-4
#Requires:	iiimf-client-lib >= 11_4-4

%description -n iiimf-server
IIIMF server is a server module of Internet/Intranet Input Method Framework.

%package -n iiimf-le-unit
Summary:      Unit language engine for iiimf-server
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on
Requires:	iiimf-server >= 11_4-4

%description -n iiimf-le-unit
Provides Unit language engine for iiimf-server.

%package -n iiimf-le-newpy
Summary:      New Pinyin language engine for iiimf-server
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on
Requires:	iiimf-server >= 11_4-4

%description -n iiimf-le-newpy
Provides New Pinyin language engine for iiimf-server

%package -n iiimf-le-hangul
Summary:      Korean language engine for iiimf-server
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on
Requires:	iiimf-server >= 11_4-4

%description -n iiimf-le-hangul
Provides Korean language engine for iiimf-server

%package -n iiimf-le-canna
Summary:      Japanese Canna engine for iiimf-server
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on
Requires:	iiimf-server >= 11_4-4

%description -n iiimf-le-canna
Provides Japanese Canna engine for iiimf-server

%package -n iiimf-x
Summary:      IIIMF XIM BackEnd module
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on
Requires:       XFree86-libs >= 4.3.0

%description -n iiimf-x
IIIMF X Provides XIM bridge modules through which legacy XIM clients should
be able to communicate to IIIMF server.

%package -n iiimf-gtk
Summary:      GTK Input Method Context Module for IIIMP
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on
BuildRequires:	glib2-devel >= 2.2.1
BuildRequires:  pango-devel >= 1.2.1
BuildRequires:	gtk2-devel >= 2.2.1
Requires:       glib2 >= 2.2.1
Requires:	pango >= 1.2.1
Requires:       gtk2 >= 2.2.1
Requires:	iiimf-client-lib >= 11_4-4

%description -n iiimf-gtk
IIIMF binding for gtk

%package -n iiimf-docs
Summary:      IIIMF documentations
Group:        System/OPENI18N/IIIMF
Autoreqprov:  on

%description -n iiimf-docs
Provides IIIMF documentations

%prep
rm -rf $RPM_BUILD_ROOT
%setup -q -n %{name}

%build
cd lib/iiimp
CFLAGS="$RPM_OPT_FLAGS"		\
./configure --prefix=%{_prefix}
make
cd ..

cd CSConv
CFLAGS="$RPM_OPT_FLAGS"		\
./configure --prefix=%{_prefix}
make
cd ..

cd EIMIL
./configure --prefix=%{_prefix}
make
cd ..

cd iiimcf
CFLAGS="$RPM_OPT_FLAGS"		\
./autogen.sh --prefix=%{_prefix}
make
cd ../..

cd iiimsf
CFLAGS="$RPM_OPT_FLAGS"		 \
./configure --prefix=%{_prefix}
make
cd ..

cd leif
CFLAGS="$RPM_OPT_FLAGS"		\
./autogen.sh --prefix=%{_prefix}
make
cd ..

cd iiimxcf/xiiimp.so
CFLAGS="$RPM_OPT_FLAGS"		\
sh ./autogen.sh --prefix=%{_prefix}
make
cd ../..

cd iiimxcf/htt_xbe
CFLAGS="$RPM_OPT_FLAGS"		\
./configure --prefix=%{_prefix}
make
cd ../..

cd iiimgcf
CFLAGS="$RPM_OPT_FLAGS"		\
./autogen.sh --prefix=%{_prefix}\
	    --sysconfdir=%{_sysconfdir}
make
cd ..

cd gnome-im-switcher
CFLAGS="$RPM_OPT_FLAGS"		\
./autogen.sh --prefix=%{_prefix}\
	    --sysconfdir=%{_sysconfdir} --libdir=%{_prefix}/%{_lib}
make
cd ..

%install
cd lib/CSConv
make DESTDIR=$RPM_BUILD_ROOT install
cd ../..

cd lib/EIMIL
make DESTDIR=$RPM_BUILD_ROOT install
cd ../..

cd lib/iiimp
make DESTDIR=$RPM_BUILD_ROOT install
cd ../..

cd lib/iiimcf
make DESTDIR=$RPM_BUILD_ROOT install
cd ../..

cd iiimsf
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/%{_initrddir}
# this hard coded entry to be removed
cp sys/RedHat/%{rcscript} $RPM_BUILD_ROOT/%{_initrddir}
cd ..

cd leif
make DESTDIR=$RPM_BUILD_ROOT install
cd ..

cd iiimxcf/xiiimp.so
make DESTDIR=$RPM_BUILD_ROOT install
cd ../..

cd iiimxcf/htt_xbe
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/iiim/
cd ../..

cd iiimgcf
make DESTDIR=$RPM_BUILD_ROOT install
cd ..

cd gnome-im-switcher
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
make DESTDIR=$RPM_BUILD_ROOT install
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL
cd ..

%post -n iiimf-gtk
%{_bindir}/gtk-query-immodules-2.0 > %{_sysconfdir}/gtk-2.0/gtk.immodules

%postun -n iiimf-gtk
%{_bindir}/gtk-query-immodules-2.0 > %{_sysconfdir}/gtk-2.0/gtk.immodules

%clean
rm -rf ${RPM_BUILD_ROOT}

#%files
#%defattr(-,root,root)
#%{prefix}/*
#%{_libdir}/gtk-2.0/*
#Disabled for 20030507-1
#/usr/X11R6/lib/X11/locale/common/*

%files -n iiimf-csconv
%defattr (-, root, root)
%{_prefix}/csconv/*
#%{_prefix}/csconv/compoundtext/*
%{_prefix}/icuconv/*.so
%{_prefix}/share/icu/1.4.0/*


%files -n iiimf-protocol-lib
%defattr (-, root, root)
%{_libdir}/libiiimp*
#%{_libdir}/im/lib/libEIMIL*


%files -n iiimf-protocol-lib-devel
%defattr (-, root, root)
%{_includedir}/iiimp.h
%{_includedir}/iiimp-character-subsets.h
%{_includedir}/iiimp-data.h
%{_includedir}/iiimp-keycode.h
%{_includedir}/iiimp-opcode.h
#%{_libdir}/im/include/EIMIL.h


%files -n iiimf-client-lib
%defattr (-, root, root)
%{_libdir}/libiiimcf*.so.*

%files -n iiimf-client-lib-devel
%defattr (-, root, root)
%{_libdir}/libiiimcf*
%{_includedir}/iiimcf.h

%files -n iiimf-server
%defattr (-, root, root)
%{_initrddir}/IIim
%{_libdir}/im/htt.conf
%{_libdir}/im/htt
%{_libdir}/im/htt_server


%files -n iiimf-le-unit
%defattr (-, root, root)
%{_libdir}/im/leif/unitle.so
%{_libdir}/im/locale/UNIT/*


%files -n iiimf-le-newpy
%defattr (-, root, root)
%{_libdir}/im/leif/newpy.*
%{_libdir}/im/locale/zh_CN/newpy/*

%files -n iiimf-le-hangul
%defattr (-, root, root)
%{_libdir}/im/leif/hangul.*
%{_libdir}/im/locale/ko_KR/hangul.conf

%files -n iiimf-le-canna
%defattr (-, root, root)
%{_libdir}/im/leif/CannaLE*

%files -n iiimf-x
%defattr (-, root, root)
#%{_sysconfdir}/iiim/xsession
%{_libdir}/im/httx
%{_libdir}/im/htt_xbe
%{_libdir}/im/xiiimp*

%files -n iiimf-gtk
%defattr (-, root, root)
%{_libdir}/gtk-2.0/*/immodules/*
%{_sysconfdir}/gconf/schemas/*
%{_libdir}/bonobo/*
%{_libexecdir}/*
%{_datadir}/locale/*
%{_datadir}/gnome-2.0/*

%files -n iiimf-docs
%defattr(-, root, root)
%doc doc/*


%changelog
* Fri Mar 15 2004 ILGYOUNG PARK <Karl.Park@Sun.COM>
- Fix up rpm build errors
* Fri Jan 9 2004 ILGYOUNG PARK <Karl.Park@Sun.COM> r11_4-4
- Initial version based on Yu Shao's spec file
