#include "SunIM.h"
#include "indic_input.h"

/* record the status of Auxiliary window */
typedef struct {
	int	x;
	int	y;
	char	on;		/* On or Off status of Auxiliary Window */
	int	engine_id;	/* Current Input Method ID */
}   TPaletteAuxStatus;

typedef enum {
	UNKNOWN_IMP,
	IIIMP,
	XIMP,
	XIMCP
}   TIMProtocolType;

typedef enum {
	UNKNOWN_CLIENT,
	JAVA_CLIENT,
	X11_CLIENT
}   TClientType;

/* data per desktop */
typedef struct {
	iml_session_t 	*current_session;
	iml_session_t 	*root_session;
	CARD8 		aux_locale_id;
	IMEArgList	ime_args[MAX_ENGINE_NUM];
} MyDataPerDesktop;

/* data per session */
typedef struct {
	TPaletteAuxStatus  	paletteaux_status;
	TIMProtocolType		protocol_type;
	TClientType		client_type;
	IMEBuffer 		ime_buffer;
} MyDataPerSession;
