#include <stdio.h>
#include "SunIM.h"
#include "indic_input.h"
#include "codetable.h"

/*********************** Key Mapping ***********************/

/*  get the keys that IME will use */
int map_keyevent_to_imekey(CodeTableStruct *hztbl, IMEKey key_event)
{
	int keycode, keystatus, keychar;

	keycode = key_event->keyCode;
	keychar = key_event->keyChar;
	keystatus = key_event->modifier;

	log_f("keycode: 0x%x, keychar:0x%x, keystatus: 0x%x\n", keycode, keychar, keystatus);
	/* normal status */
	if (keystatus  == 0) {
		/* Function Keys */
		if (keychar == 0) {
			log_f(" Function Key :%d\n", keycode);
			switch (keycode) {
				case IM_VK_ESCAPE:
					return(ESC_KEY);

				case IM_VK_BACK_SPACE:
					return(BACKSPACE_KEY);

				case IM_VK_ENTER:
					return(RETURN_KEY);

				case IM_VK_INSERT:
					return(INSERT_KEY);

				case IM_VK_DELETE:
					return(DELETE_KEY);

				case IM_VK_HOME:
					return(HOME_KEY);

				case IM_VK_END:
					return(END_KEY);

				case IM_VK_PAGE_UP:
					return(PAGEUP_KEY);

				case IM_VK_PAGE_DOWN:
					return(PAGEDOWN_KEY);

			}
			return(IME_NOT_USED_KEY);
		} else {
			/*  normal key  */
			log_f(" Normal Key :0x%x, %c\n", keychar, keychar);
			return(keychar);
		}
	}

	/*  Shift status */
	if (keystatus == IM_SHIFT_MASK) {
		if (keychar != 0) {
			/*  normal key  */
			log_f(" Ascii Key :0x%x, %c\n", keychar, keychar);
			return(keychar);
		}
	}

	/*  Ctrl status */
	if (keystatus == IM_CTRL_MASK) {
		if (keychar != 0) {
			/*  normal key  */
			unsigned char *keylist;
			int i, key_id;

			keychar = keycode | 0x80;

			key_id = -1;
			for (i = 0; i<MAX_FUNCTIONKEY_NUM; i++) {
				keylist = hztbl->functionkey[i].keylist;
				if (*keylist) {
					if (index(keylist, keychar)) {
						key_id = i;
						break;
					}
				}
			}
			
			if (key_id != -1) {
				switch (key_id) {
					case PAGEUP_KEY_ID:
						return(PAGEUP_KEY);
					case PAGEDOWN_KEY_ID:
						return(PAGEDOWN_KEY);
					case BACKSPACE_KEY_ID:
						return(BACKSPACE_KEY);
					case CLEARALL_KEY_ID:
						return(ESC_KEY);
				}
			}
		}
	}

	return (IME_NOT_USED_KEY);
}

