/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef IMUSERMGR_HH_
#define IMUSERMGR_HH_

#include <set>
#include "IMAuth.hh"
#include "IMUser.hh"


class IMUserMgr : public IMAuth
{
    struct userentry {
	char *username;
	char *password;
	access_type at;
    };
    int alloced_ue_num;
    int ue_num;
    userentry *pue;
    access_type sysuser_at;

    int adjust_pue_slot_size(int newsize);
    int check_password_with_crypt(
	const char *pwd,
	const char *enc_pwd
    );
    IMAuth::access_type get_internal_userentry(
	const char *user,
	const char *password
    );

    typedef map<u16string, IMUser*> IMUserMap;
    IMUserMap usermap;

protected:
    virtual int check_password(
	const char *user,
	const char *password
    );

public:
    void set_systemuser_permission(
	IMAuth::access_type at
    ) { sysuser_at = at; }
    int add_user(
	const char *user,
	const char *password,
	access_type at
    );

    IMUser *create_imuser(
	int fd,
	const char *user,
	const char *password
    );

    IMUserMgr();
    virtual ~IMUserMgr();
};

#endif /* not IMUSERMGR_HH_ */
    
/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
