#include <config.h>
#include <stdio.h>
#include "IMSvrCfg.hh"
#include "IMUtil.hh"
#include "IMLog.hh"

void
IMSvrCfg::initialize()
{
    initstr(IMDIR, "IM main directory.", "/usr/lib/im");
    initstr(BASICLOCALE, "Locale used by default", "C");
#ifdef WIN32
    initstr(IFPATHNAME, "Language Engine module directory",
	   "D:\\WINNT\\System32\\iiimf");
#else
    initstr(IFPATHNAME, "Language Engine module directory",
	   "/usr/lib/im/leif");
#endif
    initstr(IFNAME, "Language Engine name", "");
    initstr(PORT, "Port or service name", "9010");
    initstr(HOSTNAME, "host name", "localhost");
#ifdef WIN32
    initstr(CONFIGFILE, "Configuration file", "D:\\WINNT\\System32\\htt.conf");
#else
    initstr(CONFIGFILE, "Configuration file", "/usr/lib/im/htt.conf");
#endif
    initstr(CONVERSIONKEYS, "Conversion ON keys", "<Ctrl>space");
    initstr(LABEL, "Label type", "numeric");
    initbool(SETTRIGGEROFFKEYS, "set trigger off keys", false);
    // initstr(IMCONFIG, "/usr/lib/im/etc/im.config");
    // initbool(DIRECT_XSUNIM, true);
    initstr(LOG_FACILITY, "syslog facility", "USER");
    initstr(LOG_LEVEL, "log level", "NORMAL");
    initstr(MESSAGE_LOCALE, "message locale", "C");
    initnum(LOOKUPROW, "The number of lookup-choice rows.", 4);
    initnum(LOOKUPCOL, "The number of lookup-choice columns.", 4);
    initbool(NODAEMON, "Don't transit to daemon mode", false);
    initbool(DEBUGFLAG, "debug mode", false);
}

void
IMSvrCfg::
initbool(
    enum IMSvrCfgOpt opt,
    const char* desc,
    bool boolval
)
{
    popts[opt].opt = opt;
    popts[opt].type = ARG_BOOL;
    popts[opt].description = desc;
    popts[opt].v.b = boolval;
}
 
void
IMSvrCfg::
initnum(
    enum IMSvrCfgOpt opt,
    const char* desc,
    int numval
)
{
    popts[opt].opt = opt;
    popts[opt].type = ARG_NUMBER;
    popts[opt].description = desc;
    popts[opt].v.n = numval;
}

void
IMSvrCfg::
initstr(
    enum IMSvrCfgOpt opt,
    const char* desc,
    const char* strval
)
{
    popts[opt].opt = opt;
    popts[opt].type = ARG_STRING;
    popts[opt].description = desc;
    popts[opt].v.s = strval;
}

void
IMSvrCfg::
setbool(
    enum IMSvrCfgOpt opt,
    bool boolval
)
{
    if (popts[opt].type != ARG_BOOL) {
	ERROR_INTERNAL("Invalid argument access.");
    }
    popts[opt].v.b = boolval;
}
 
void
IMSvrCfg::
setnum(
    enum IMSvrCfgOpt opt,
    int numval
)
{
    if (popts[opt].type != ARG_NUMBER) {
	ERROR_INTERNAL("Invalid argument access.");
    }
    popts[opt].v.n = numval;
}

void
IMSvrCfg::
setstr(
    enum IMSvrCfgOpt opt,
    const char* strval
)
{
    if (popts[opt].type != ARG_STRING) {
	ERROR_INTERNAL("Invalid argument access.");
    }
    popts[opt].v.s = strval;
}


bool
IMSvrCfg::
get_boolval(
    enum IMSvrCfgOpt opt
) const
{
    if ((opt >= CFGOPT_LAST)
	|| (popts[opt].type != ARG_BOOL)) {
	ERROR_INTERNAL("Invalid argument access.");
    }

    return popts[opt].v.b;
}

int
IMSvrCfg::
get_numval(
    enum IMSvrCfgOpt opt
) const
{
    if ((opt >= CFGOPT_LAST)
	|| (popts[opt].type != ARG_NUMBER)) {
	ERROR_INTERNAL("Invalid argument access.");
    }

    return popts[opt].v.n;
}

const char*
IMSvrCfg::
get_strval(
    enum IMSvrCfgOpt opt
) const
{
    if ((opt >= CFGOPT_LAST)
	|| (popts[opt].type != ARG_STRING)) {
	ERROR_INTERNAL("Invalid argument access.");
    }

    return popts[opt].v.s.c_str();
}

void
IMSvrCfg::showall() const
{
    int i;
    for (i = 0; i < CFGOPT_LAST; i++) {
	switch(popts[i].type) {
	  case ARG_BOOL:
	   if (popts[i].v.b) {
	       LOG_DEBUG("%s[%d]:true", popts[i].description.c_str(), (int)popts[i].opt);
	   } else {
	       LOG_DEBUG("%s[%d]:false", popts[i].description.c_str(), (int)popts[i].opt);
	   }
	   break;
	  case ARG_NUMBER:
	   LOG_DEBUG("%s[%d]:%d", popts[i].description.c_str(), (int)popts[i].opt, popts[i].v.n);
	   break;
	  case ARG_STRING:
	   LOG_DEBUG("%s[%d]:%s", popts[i].description.c_str(), (int)popts[i].opt, popts[i].v.s.c_str());
	   break;
	  default:
	   ERROR_INTERNAL("Invalid arg type.");
	   break;
	}
    }

    return;
}

IMSvrCfg::IMSvrCfg(
	const IMSvrCfg& base
)
{
    command_name = base.command_name;
    popts = base.popts;
    pbase = &base;
}

IMSvrCfg::IMSvrCfg(
    string cmdname
)
{
    command_name = cmdname;
    popts = new CfgVal[CFGOPT_LAST];
    pbase = NULL;
    initialize();
}

IMSvrCfg::~IMSvrCfg()
{
    if (!pbase) delete[] popts;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
