/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VisibleMemberMap {
    private boolean noVisibleMembers = true;
    public static final int INNERCLASSES = 0;
    public static final int ENUM_CONSTANTS = 1;
    public static final int FIELDS = 2;
    public static final int CONSTRUCTORS = 3;
    public static final int METHODS = 4;
    public static final int ANNOTATION_TYPE_MEMBER_OPTIONAL = 5;
    public static final int ANNOTATION_TYPE_MEMBER_REQUIRED = 6;
    public static final int NUM_MEMBER_TYPES = 7;
    public static final String STARTLEVEL = "start";
    private final List visibleClasses = new ArrayList();
    private final Map memberNameMap = new HashMap();
    private final Map classMap = new HashMap();
    private final ClassDoc classdoc;
    private final int kind;
    private final boolean nodepr;

    public VisibleMemberMap(ClassDoc classDoc, int n, boolean bl) {
        this.classdoc = classDoc;
        this.nodepr = bl;
        this.kind = n;
        new ClassMembers(classDoc, STARTLEVEL).build();
    }

    public List getVisibleClassesList() {
        this.sort(this.visibleClasses);
        return this.visibleClasses;
    }

    private List getInheritedPackagePrivateMethods(Configuration configuration) {
        ArrayList arrayList = new ArrayList();
        for (ClassDoc classDoc : this.visibleClasses) {
            if (classDoc == this.classdoc || !classDoc.isPackagePrivate() || Util.isLinkable(classDoc, configuration)) continue;
            arrayList.addAll(this.getMembersFor(classDoc));
        }
        return arrayList;
    }

    public List getLeafClassMembers(Configuration configuration) {
        List list = this.getMembersFor(this.classdoc);
        list.addAll(this.getInheritedPackagePrivateMethods(configuration));
        return list;
    }

    public List getMembersFor(ClassDoc classDoc) {
        ClassMembers classMembers = (ClassMembers)this.classMap.get(classDoc);
        if (classMembers == null) {
            return new ArrayList();
        }
        return classMembers.getMembers();
    }

    private void sort(List list) {
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        ArrayList<ClassDoc> arrayList2 = new ArrayList<ClassDoc>();
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc classDoc = (ClassDoc)list.get(i);
            if (classDoc.isClass()) {
                arrayList.add(classDoc);
                continue;
            }
            arrayList2.add(classDoc);
        }
        list.clear();
        list.addAll(arrayList);
        list.addAll(arrayList2);
    }

    private void fillMemberLevelMap(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            Object object = this.getMemberKey((ProgramElementDoc)list.get(i));
            HashMap hashMap = (HashMap)this.memberNameMap.get(object);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.memberNameMap.put(object, hashMap);
            }
            hashMap.put(list.get(i), string);
        }
    }

    private void purgeMemberLevelMap(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            Object object = this.getMemberKey((ProgramElementDoc)list.get(i));
            Map map = (Map)this.memberNameMap.get(object);
            if (!string.equals(map.get(list.get(i)))) continue;
            map.remove(list.get(i));
        }
    }

    public boolean noVisibleMembers() {
        return this.noVisibleMembers;
    }

    private ClassMember getClassMember(MethodDoc methodDoc) {
        for (Object k : this.memberNameMap.keySet()) {
            if (k instanceof String || !((ClassMember)k).isEqual(methodDoc)) continue;
            return (ClassMember)k;
        }
        return new ClassMember(methodDoc);
    }

    private Object getMemberKey(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isConstructor()) {
            return programElementDoc.name() + ((ExecutableMemberDoc)programElementDoc).signature();
        }
        if (programElementDoc.isMethod()) {
            return this.getClassMember((MethodDoc)programElementDoc);
        }
        if (programElementDoc.isField() || programElementDoc.isEnumConstant() || programElementDoc.isAnnotationTypeElement()) {
            return programElementDoc.name();
        }
        String string = programElementDoc.name();
        string = string.indexOf(46) != 0 ? string.substring(string.lastIndexOf(46), string.length()) : string;
        return "clint" + string;
    }

    private class ClassMembers {
        private ClassDoc mappingClass;
        private List members = new ArrayList();
        private String level;

        public List getMembers() {
            return this.members;
        }

        private ClassMembers(ClassDoc classDoc, String string) {
            this.mappingClass = classDoc;
            this.level = string;
            if (VisibleMemberMap.this.classMap.containsKey(classDoc) && string.startsWith(((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)classDoc)).level)) {
                VisibleMemberMap.this.purgeMemberLevelMap(this.getClassMembers(classDoc, false), ((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)classDoc)).level);
                VisibleMemberMap.this.classMap.remove(classDoc);
                VisibleMemberMap.this.visibleClasses.remove(classDoc);
            }
            if (!VisibleMemberMap.this.classMap.containsKey(classDoc)) {
                VisibleMemberMap.this.classMap.put(classDoc, this);
                VisibleMemberMap.this.visibleClasses.add(classDoc);
            }
        }

        private void build() {
            if (VisibleMemberMap.this.kind == 3) {
                this.addMembers(this.mappingClass);
            } else {
                this.mapClass();
            }
        }

        private void mapClass() {
            ClassDoc classDoc;
            Object object;
            this.addMembers(this.mappingClass);
            ClassDoc[] classDocArray = this.mappingClass.interfaces();
            for (int i = 0; i < classDocArray.length; ++i) {
                object = this.level + 1;
                ClassMembers classMembers = new ClassMembers(classDocArray[i], (String)object);
                classMembers.mapClass();
            }
            if (this.mappingClass.isClass() && (classDoc = this.mappingClass.superclass()) != null && !this.mappingClass.equals(classDoc)) {
                object = new ClassMembers(classDoc, this.level + "c");
                super.mapClass();
            }
        }

        private void addMembers(ClassDoc classDoc) {
            List list = this.getClassMembers(classDoc, true);
            ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)list.get(i);
                if (this.found(this.members, programElementDoc) || !this.memberIsVisible(programElementDoc) || this.isOverridden(programElementDoc, this.level)) continue;
                arrayList.add(programElementDoc);
            }
            if (arrayList.size() > 0) {
                VisibleMemberMap.this.noVisibleMembers = false;
            }
            this.members.addAll(arrayList);
            VisibleMemberMap.this.fillMemberLevelMap(this.getClassMembers(classDoc, false), this.level);
        }

        private boolean memberIsVisible(ProgramElementDoc programElementDoc) {
            if (programElementDoc.containingClass().equals(VisibleMemberMap.this.classdoc)) {
                return true;
            }
            if (programElementDoc.isPrivate()) {
                return false;
            }
            if (programElementDoc.isPackagePrivate()) {
                return programElementDoc.containingClass().containingPackage().equals(VisibleMemberMap.this.classdoc.containingPackage());
            }
            return true;
        }

        private List getClassMembers(ClassDoc classDoc, boolean bl) {
            if (classDoc.isEnum() && VisibleMemberMap.this.kind == 3) {
                return Arrays.asList(new ProgramElementDoc[0]);
            }
            ProgramElementDoc[] programElementDocArray = null;
            switch (VisibleMemberMap.this.kind) {
                case 5: {
                    programElementDocArray = classDoc.isAnnotationType() ? this.filter((AnnotationTypeDoc)classDoc, false) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 6: {
                    programElementDocArray = classDoc.isAnnotationType() ? this.filter((AnnotationTypeDoc)classDoc, true) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 0: {
                    programElementDocArray = classDoc.innerClasses(bl);
                    break;
                }
                case 1: {
                    programElementDocArray = classDoc.enumConstants();
                    break;
                }
                case 2: {
                    programElementDocArray = classDoc.fields(bl);
                    break;
                }
                case 3: {
                    programElementDocArray = classDoc.constructors();
                    break;
                }
                case 4: {
                    programElementDocArray = classDoc.methods(bl);
                    break;
                }
                default: {
                    programElementDocArray = new ProgramElementDoc[]{};
                }
            }
            if (VisibleMemberMap.this.nodepr) {
                return Util.excludeDeprecatedMembersAsList(programElementDocArray);
            }
            return Arrays.asList(programElementDocArray);
        }

        private AnnotationTypeElementDoc[] filter(AnnotationTypeDoc annotationTypeDoc, boolean bl) {
            AnnotationTypeElementDoc[] annotationTypeElementDocArray = annotationTypeDoc.elements();
            ArrayList<AnnotationTypeElementDoc> arrayList = new ArrayList<AnnotationTypeElementDoc>();
            for (int i = 0; i < annotationTypeElementDocArray.length; ++i) {
                if ((!bl || annotationTypeElementDocArray[i].defaultValue() != null) && (bl || annotationTypeElementDocArray[i].defaultValue() == null)) continue;
                arrayList.add(annotationTypeElementDocArray[i]);
            }
            return arrayList.toArray(new AnnotationTypeElementDoc[0]);
        }

        private boolean found(List list, ProgramElementDoc programElementDoc) {
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc programElementDoc2 = (ProgramElementDoc)list.get(i);
                if (!Util.matches(programElementDoc2, programElementDoc)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridden(ProgramElementDoc programElementDoc, String string) {
            Map map = (Map)VisibleMemberMap.this.memberNameMap.get(VisibleMemberMap.this.getMemberKey(programElementDoc));
            if (map == null) {
                return false;
            }
            String string22 = null;
            for (String string22 : map.values()) {
                if (!string22.equals(VisibleMemberMap.STARTLEVEL) && (!string.startsWith(string22) || string.equals(string22))) continue;
                return true;
            }
            return false;
        }
    }

    private class ClassMember {
        private Set members = new HashSet();

        public ClassMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public void addMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public boolean isEqual(MethodDoc methodDoc) {
            for (MethodDoc methodDoc2 : this.members) {
                if (!Util.executableMembersEqual(methodDoc, methodDoc2)) continue;
                this.members.add(methodDoc);
                return true;
            }
            return false;
        }
    }
}

