/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.internal.toolkit.ConstantsSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class ConstantsSummaryWriterImpl
extends HtmlDocletWriter
implements ConstantsSummaryWriter {
    ConfigurationImpl configuration;
    private ClassDoc currentClassDoc;

    public ConstantsSummaryWriterImpl(ConfigurationImpl configurationImpl) throws IOException {
        super(configurationImpl, "constant-values.html");
        this.configuration = configurationImpl;
    }

    public void writeHeader() {
        this.printHtmlHeader(this.configuration.getText("doclet.Constants_Summary"), null, true);
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.printText("doclet.Constants_Summary");
        this.h1End();
        this.centerEnd();
        this.hr(4, "noshade");
    }

    public void writeFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    public void writeContentsHeader() {
        this.bold(this.configuration.getText("doclet.Contents"));
        this.ul();
    }

    public void writeContentsFooter() {
        this.ulEnd();
        this.println();
    }

    public void writeLinkToPackageContent(PackageDoc packageDoc, String string, Set set) {
        String string2 = packageDoc.name();
        this.li();
        if (string2.length() == 0) {
            this.printHyperLink("#unnamed_package", "&lt;Unnamed&gt;");
        } else {
            this.printHyperLink("#" + string, string + ".*");
            set.add(string);
        }
        this.println();
    }

    public void writeConstantMembersHeader(ClassDoc classDoc) {
        String string = classDoc.isPublic() || classDoc.isProtected() ? this.getLink(new LinkInfoImpl(6, classDoc, false)) : classDoc.qualifiedName();
        String string2 = classDoc.containingPackage().name();
        if (string2.length() > 0) {
            this.writeClassName(string2 + "." + string);
        } else {
            this.writeClassName(string);
        }
    }

    public void writeConstantMembersFooter(ClassDoc classDoc) {
        this.tableFooter(false);
        this.p();
    }

    protected void writeClassName(String string) {
        this.table(1, 3, 0);
        this.trBgcolorStyle("#EEEEFF", "TableSubHeadingColor");
        this.thAlignColspan("left", 3);
        this.write(string);
        this.thEnd();
        this.trEnd();
    }

    private void tableFooter(boolean bl) {
        this.fontEnd();
        if (bl) {
            this.thEnd();
        } else {
            this.tdEnd();
        }
        this.trEnd();
        this.tableEnd();
        this.p();
    }

    public void writePackageName(PackageDoc packageDoc, String string) {
        String string2;
        if (string.length() == 0) {
            this.anchor("unnamed_package");
            string2 = "&lt;Unnamed&gt;";
        } else {
            this.anchor(string);
            string2 = string;
        }
        this.table(1, "100%", 3, 0);
        this.trBgcolorStyle("#CCCCFF", "TableHeadingColor");
        this.thAlign("left");
        this.font("+2");
        this.write(string2 + ".*");
        this.tableFooter(true);
    }

    public void writeConstantMembers(ClassDoc classDoc, List list) {
        this.currentClassDoc = classDoc;
        for (int i = 0; i < list.size(); ++i) {
            this.writeConstantMember((FieldDoc)list.get(i));
        }
    }

    private void writeConstantMember(FieldDoc fieldDoc) {
        this.trBgcolorStyle("white", "TableRowColor");
        this.anchor(this.currentClassDoc.qualifiedName() + "." + fieldDoc.name());
        this.writeTypeColumn(fieldDoc);
        this.writeNameColumn(fieldDoc);
        this.writeValue(fieldDoc);
        this.trEnd();
    }

    private void writeTypeColumn(FieldDoc fieldDoc) {
        this.tdAlign("right");
        this.font("-1");
        this.code();
        StringTokenizer stringTokenizer = new StringTokenizer(fieldDoc.modifiers());
        while (stringTokenizer.hasMoreTokens()) {
            this.print(stringTokenizer.nextToken() + "&nbsp;");
        }
        this.printLink(new LinkInfoImpl(6, fieldDoc.type()));
        this.codeEnd();
        this.fontEnd();
        this.tdEnd();
    }

    private void writeNameColumn(FieldDoc fieldDoc) {
        this.tdAlign("left");
        this.code();
        this.printDocLink(6, fieldDoc, fieldDoc.name(), false);
        this.codeEnd();
        this.tdEnd();
    }

    private void writeValue(FieldDoc fieldDoc) {
        this.tdAlign("right");
        this.code();
        this.print(Util.escapeHtmlChars(fieldDoc.constantValueExpression()));
        this.codeEnd();
        this.tdEnd();
    }
}

