/*
 *  IHU -- I Hear U, easy VoIP application using Speex and Qt
 *
 *  Copyright (C) 2003-2005 M. Trotta - <mrotta@users.sourceforge.net>
 *
 *  http://ihu.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#ifndef PLAYER_HPP
#define PLAYER_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <qobject.h>
#include <qstring.h>
#include <qtimer.h>
#include <alsa/asoundlib.h>

#include "SoundTouch.h"

#define PLAY_DRIVER_ALSA 0
#define PLAY_DRIVER_JACK 1

using namespace soundtouch;

#ifdef HAVE_LIBJACK
#include <jack/jack.h>
#endif

class Player: public QObject {
	Q_OBJECT
public:
	Player();
	~Player(void);
	void init(unsigned int, int);
	void initAlsa(const char*);
	bool flush();
	void playAlsa(float *, int);
	void play(float *, int);
	void end();
	void setup(int, QString, int);
	bool ready();
	bool ready(int);
	void setAdr(bool, float, float, float);
	void setAgc(bool, float, float, float, float);
	void ring(short *, int);
	void update_frames(int frames);
	bool isWorking();
	void reset();
#ifdef HAVE_LIBJACK
	void playJack(float *, int);
	void initJack();
	void endJack();
#endif
private:
	int i;
	int err;
	unsigned int sample_rate;
	int frame_size;
	snd_pcm_t *playback_handle;
	snd_pcm_sframes_t delayNow;
	float *audioBuffer;
	int driver;
	int tempDriver;
	float ringvolume;
	float delay;
	float minDelay;
	float maxDelay;
	float stretch;
	float tempoChange;
	float fdel;
	bool adr;
	bool agc;
	SoundTouch *pSoundTouch;
	float level;
	float amp;
	float minamp;
	float maxamp;
	float agc_err;
	float agc_step;
	int readyFrames;
	int prebuffer;
	int preframes;
	QTimer *timer;
	short *shortBuffer;
	bool working;
	QString interface;
	SAMPLETYPE *sampleBuffer;
#ifdef HAVE_LIBJACK
	jack_client_t *jack_handle;
	jack_port_t *jack_out;
	jack_default_audio_sample_t *jackdata;
	static int jack_callback(jack_nframes_t , void *);
	int jack_play(jack_nframes_t);
#endif
public slots:
	void put(float *, int);
	void alsa_callback();
signals:
	void suspend();
	void warning(QString);
};

#endif

