/*
 *  IHU -- I Hear U, easy VoIP application using Speex and Qt
 *
 *  Copyright (C) 2003-2005 M. Trotta - <mrotta@users.sourceforge.net>
 *
 *  http://ihu.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#ifndef ___IHUNOGUI_HPP___
#define ___IHUNOGUI_HPP___

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qobject.h>
#include <qstring.h>

#include "Error.hpp"
#include "Config.hpp"
#include "Logger.hpp"
#include "Rsa.hpp"
#include "Player.hpp"
#include "Receiver.hpp"
#include "Recorder.hpp"
#include "Transmitter.hpp"

class IhuNoGui : public QObject
{
	Q_OBJECT
public:
	IhuNoGui();
	~IhuNoGui();
	void initIhu();
	void startReceiver();
	void agcRefresh(bool);
	void adrRefresh(bool);
	void call(QString);
	void stopAll();
	void playFile(QString);
	void cryptOn();
	void changeKey();
	void disableIn();
	void disableOut();
	void applySettings();
	void waitForCalls();
	void ringOn(bool);
private:
	Config& config;
	Rsa *rsa;
	Player *player;
	Receiver *receiver;
	Recorder *recorder;
	Transmitter *transmitter;
	Logger *logger;
	bool listening;
	bool fromFile;
	bool muteMic;
	bool muteSpk;
	bool crypt;
public slots:
	void newConnection(int,int,struct sockaddr_in);
	void stopSignal();
	void abortAll(QString);
	void sendKey();
	void sendKeyRequest();
	void warning(QString);
	void message(QString);
	void ringMessage();
	void receivedNewKey(QString);
};

#endif
