/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IPARTICLESPLITTER_H
#define IPARTICLESPLITTER_H


#include "igenericfilter.h"
#include <vtkPolyDataToPolyDataFilter.h>


class iHistogramMaker;
class iRangeCollection;
class iRangeMapping;

class vtkPoints;
class vtkCellArray;
class vtkFloatArray;
class vtkFloatArray;


class iParticleSplitter : public iGenericPolyDataToPolyDataFilter<vtkPolyDataToPolyDataFilter>
{
	
	IGENERICFILTER_DECLARE(iParticleSplitter,vtkPolyDataToPolyDataFilter);

public:
	
	int GetNumberOfPieces() const;

	void SetAttributeToSplit(int a);
	inline int GetAttributeToSplit() const { return mAtt; }
	
	void SetSplitRangesStretch(int s);
	int GetSplitRangesStretch() const;
	
	void SetSplitRangesTiled(bool s);
	bool GetSplitRangesTiled() const;
	
	void SetSplitRangesMinMax(float amin, float amax);
	void GetSplitRangesMinMax(float &amin, float &amax) const;

	void SetSplitRangeLimits(int n, float amin, float amax);
	void GetSplitRangeLimits(int n, float &amin, float &amax) const;

	void ResetRange(){ mRangeSet = false; }

	bool CreateGroup();
	bool DeleteGroup(int n);

	iRangeMapping* GetSplitRanges(); // for direct access

	void TakeOverData(bool);

	float GetMemorySize() const;

protected:
	
	virtual ~iParticleSplitter();

	virtual void SyncWithData(const iDataSyncRequest &r);

	virtual void ProduceOutput();
	
private:

	void UpdateRange();

	bool mRangeSet, mOwnsData;

	int mAtt;
	static float mAttRange;
	bool mSorted;

	iRangeCollection *mRanges;
	iRangeMapping *mMapping;
	iHistogramMaker *mHistogramMaker;

	vtkPoints *mSavedPoints;
	vtkCellArray *mSavedVerts;
	vtkFloatArray *mSavedNorms;
	vtkFloatArray *mSavedAtts;

	unsigned long mSortingMTime;
};

#endif // IPARTICLESPLITTER_H
 
