/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggframeposition.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "ishell.h"
#include "iviewsubject.h"

#include "iggframedoublebutton.h"
#include "iggwidgetkeylineedit.h"
#include "iggwidgetkeyselectionbox.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetotherbutton.h"

#include "iggparameter.h"
using namespace iggParameter;


namespace iggFramePosition_Private
{
	class MoveFocalPointFrame : public iggFrameMoveFocalPointButton
	{
		
	public:
		
		MoveFocalPointFrame(const iObjectKey &key, iggFrame *parent) : iggFrameMoveFocalPointButton(parent,false,true), mKey(key)
		{
		}

		virtual void GetPosition(double x[3]) const
		{
			if(!this->GetShell()->GetControlModule()->QueryValue(mKey,x,3))
			{
				IERROR_LOW("Unable to query the position value.");
			}
		}

	protected:

		const iObjectKey &mKey;
	};

	class MoveToWidget : public iggWidgetKeyComboBox
	{

	public:

		MoveToWidget(const iObjectKey &key, iggFrame *parent) : iggWidgetKeyComboBox("",1,key,parent)
		{
			this->InsertItem("Move to...");
			this->InsertItem("  Picked point");
			this->InsertItem("  Focal point");
			this->InsertItem("  Box center");

			this->SetActionKey(true);
		}

		virtual bool ExecuteControl(bool final, int val)
		{
			bool ret = this->iggWidgetKeyComboBox::ExecuteControl(final,val);
			this->UpdateWidgetBody();
			return ret;
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			this->UpdateValue(-1);
		}
	};
};


using namespace iggFramePosition_Private;


iggFramePosition::iggFramePosition(const iString &title, const iObjectKey &key, iggFrame *parent, bool withFocalPointMove) : iggFrame(title,parent,1)
{
	if(key.Argument()!=iObjectKey::_Double || key.Dimension()!=3)
	{
		IERROR_FATAL("iggFramePosition is configured incorrectly.");
	}

	this->AddLine(new iggWidgetKeyPositionSlider(8,"%b%+X",key,_RenderModeUseGlobal,this,0));
	this->AddLine(new iggWidgetKeyPositionSlider(8,"%b%+Y",key,_RenderModeUseGlobal,this,1));
	this->AddLine(new iggWidgetKeyPositionSlider(8,"%b%+Z",key,_RenderModeUseGlobal,this,2));

	const iObjectKey *p = iObjectKeyRegistry::FindKey(iViewSubject::KeyMoveTo().RetypedKey(key.Type()));
	if(p != 0)
	{
		this->AddLine(new MoveToWidget(*p,this));
	}

	if(withFocalPointMove)
	{
		this->AddLine(new MoveFocalPointFrame(key,this));
	}
}

