/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#include "iversion.h"


//
//  IFrIT version
//
#define IVERSION_BASE			"3.1.5"

#define IVERSION_EXT_HART		"2.1.5"
#define IVERSION_EXT_MV			"1.0.4"
#define IVERSION_EXT_VTK		"1.0.0b1"
#define IVERSION_EXT_GADGET		"1.0.0b2"

//
//  History
//
//  060608  Base-3.0.0b1  HART-2.0.0b1  MV-1.0.0b1  -- First beta release
//  060609  Base-3.0.0b2  HART-2.0.0b2  MV-1.0.0b2  -- Added special locations in CrossSectionViewSubject
//  060622  Base-3.0.0b3  HART-2.0.0b3  MV-1.0.0b3  -- Added coordinate system switch for HART extension
//  060701  Base-3.0.0b4  HART-2.0.0b4  MV-1.0.0b4  -- Added abstract/generic filters for porting, cleaned up class names
//  060707  Base-3.0.0b5  HART-2.0.0b5  MV-1.0.0b5  -- Completed Script Debugger
//  060721  Base-3.0.0b6  HART-2.0.0b6  MV-1.0.0b6  -- Completed port to Qt4
//  060728  Base-3.0.0b7  HART-2.0.0b7  MV-1.0.0b7  -- Internal changes, docking fixed (?)
//  060815  Base-3.0.0b8  HART-2.0.0b8  MV-1.0.0b8  -- New icons, docking now really fixed, x-section in texture mode on multiple processors is fixed
//                                                     Includes 3D texture model for volume rendering and direct MPEG/AVI movie creation
//  060817  Base-3.0.0    HART-2.0.0    MV-1.0.0    -- First release: basic things seem to work now.
//  060830  Base-3.0.1    HART-2.0.1    MV-1.0.0    -- Some bug fixes
//  060926  Base-3.0.2    HART-2.0.2    MV-1.0.0    -- Refactored for simplified extensions (ViewSubjects etc)
//  060930  Base-3.0.3    HART-2.0.3    MV-1.0.0    -- Need to re-release, created a branch in CVS too early by mistake
//  061003  Base-3.0.4    HART-2.0.4    MV-1.0.0    -- Added special brightness palette, fixed iArray out-of-boundary bug, fixed DataExplorer bug
//  061010  Base-3.0.5    HART-2.0.5    MV-1.0.0    -- fixed Interactor bug, HART isosurface bugs(?), more iArray out-of-boundary bugs
//  061119  Base-3.0.6    HART-2.0.6    MV-1.0.0    -- fixed DataLimits+clones bug, RulerDialog bug, parallel stitch bug, added window list idalog, x-section placement enhancements
//  061120  Base-3.0.7    HART-2.0.7    MV-1.0.0    -- work around vtkMarchingContourFilter multi-threaded bug.
//  061221  Base-3.0.8    HART-2.0.8    MV-1.0.1    -- internal changes, pseudo-color composing in ImageComposer, minor GUI modifications, bug fixes.
//  070203  Base-3.0.9    HART-2.0.9    MV-1.0.1    -- internal changes to particle masking, new masking modes, bug fixes
//
//  070325  Base-3.1.0    HART-2.1.0    MV-1.0.2    VTK-1.0.0b0     GADGET-1.0.0b0 
//          split DataSubject into DataSubject proper and DataFileLoader
//          added VTK & GADGET extensions
//          fixed MultiView full-screen mode bugs
//
//  070422  Base-3.1.1    HART-2.1.2    MV-1.0.2    VTK-1.0.0b0     GADGET-1.0.0b1
//          fixed marker Create/Delete panel bug
//          other stylistic bug fixes
//          redone volume rendering interface
//          HART 2D & 3D texture volume rendering by uniform resampling
//
//  070502  Base-3.1.2    HART-2.1.3    MV-1.0.3    VTK-1.0.0b0     GADGET-1.0.0b2
//			C-style casting replaced whereever possible
//			ViewModule::LabelOffset property added
//			Fixed bugs in iDataExplorer
//			Fixed bugs in recognizing animatable filename without a suffix
//
//  070508  Base-3.1.3    HART-2.1.3    MV-1.0.3    VTK-1.0.0b0     GADGET-1.0.0b2
//			Fixed bugs with saving markers and animation not stopping on error
//			New markers are placed in the camera focal point
//
//  070527  Base-3.1.4    HART-2.1.4    MV-1.0.4    VTK-1.0.0b1     GADGET-1.0.0b2
//			Added external image as a background
//			Fixed batch mode and channeling output
//			Fixed shifting
//
//  070618  Base-3.1.5    HART-2.1.5    MV-1.0.4    VTK-1.0.0b1     GADGET-1.0.0b2
//			Added zooms in Composer
//			Fixed particle picking
//			Added particle auto-scaling
//			Fixed offscreen mode with Mesa libraries
//

//
//  ToDo (major additions)
//
//  1. Point sprats for particles
//  2. Multiple images in Composer
//

#if ISHELL_INCLUDED(ISHELL_QT)
#include <qglobal.h>
#endif


const iString iVersion::GetVersion()
{ 
	return IVERSION_BASE;
}


const iString iVersion::GetIncludedExtensions()
{ 
	iString tmp; 
#if IEXTENSION_INCLUDED(IEXTENSION_HART)
	tmp += iString("HART extension v") + IVERSION_EXT_HART +";";
#endif
#if IEXTENSION_INCLUDED(IEXTENSION_MV)
	tmp += iString("MultiView extension v") + IVERSION_EXT_MV +";";
#endif
#if IEXTENSION_INCLUDED(IEXTENSION_GADGET)
	tmp += iString("GADGET extension v") + IVERSION_EXT_GADGET +";";
#endif
#if IEXTENSION_INCLUDED(IEXTENSION_VTK)
	tmp += iString("Native-VTK extension v") + IVERSION_EXT_VTK +";";
#endif
	return tmp;
}


const iString iVersion::GetIncludedShells()
{ 
	iString tmp;
#if ISHELL_INCLUDED(ISHELL_CL)
	tmp += iString("Command-line shell") + ";";
#endif
#if ISHELL_INCLUDED(ISHELL_QT)
	tmp += iString("Qt-based GUI shell (Qt ") + QT_VERSION_STR + ");";
#endif
#if ISHELL_INCLUDED(ISHELL_FX)
	tmp += iString("FOX-based GUI shell") + ";";
#endif
	return tmp;
}
