/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggpagevolume.h"


#include "icontrolmodule.h"
#include "iimagefactory.h"
#include "ishell.h"
#include "iviewmodule.h"
#include "ivolumeviewsubject.h"

#include "iggdatatypeprovider.h"
#include "iggframedatavariablelist.h"
#include "iggframefunctionmapping.h"
#include "iggframematerialproperties.h"
#include "iggframepaletteselection.h"
#include "iggframereplicate.h"
#include "iggwidgetkeybutton.h"
#include "iggwidgetkeyselectionbox.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetotherbutton.h"

#include "ibgframesubject.h"
#include "ibgwidgetbuttonsubject.h"

#include "iggsubjectfactory.h"
#include "iggparameter.h"
using namespace iggParameter;

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"
#include"iggwidgetkeyslidertemplate.h"


namespace iggPageVolume_Private
{
	//
	//  Helper widgets
	//
	class WindowSizeFrame : public iggFrame
	{
		
	public:
		
		WindowSizeFrame(iggFrame *parent) : iggFrame("Window size",parent,1)
		{
			mSubject1 = iggSubjectFactory::CreateWidgetButtonSubject(this,_ButtonTypePushButton,"256x256",1);
			mSubject2 = iggSubjectFactory::CreateWidgetButtonSubject(this,_ButtonTypePushButton,"512x512",2);
			mSubject3 = iggSubjectFactory::CreateWidgetButtonSubject(this,_ButtonTypePushButton,"1024x1024",3);

			mSubject->PlaceWidget(0,0,mSubject1,1,true);
			mSubject->PlaceWidget(0,1,mSubject2,1,true);
			mSubject->PlaceWidget(0,2,mSubject3,1,true);

			this->SetBaloonHelp("Sets the size of the current visualization window to a power of 2","When using the VolumePro board for volume rendering, IFrIT relies on OpenGL textures to display the scene. Since OpenGL textures must have dimensions that are powers of two, the performance is optimal when the visualization window size corresponds exactly to the texture size. These buttons will quickly resize the visualization window to be a power of two size.");
		}

	protected:
		
		virtual void OnVoid1Body()
		{
			static int iv[2] = { 256, 256};

			iString ws;
			this->GetShell()->GetControlModule()->PackCommand(ws,iViewModule::KeySize(),iv,2);
			this->GetShell()->GetControlModule()->Execute(ws,true,iggWidgetKeyHandlerBase::GetGlobalExecuteFlags());
		}

		virtual void OnVoid2Body()
		{
			static int iv[2] = { 512, 512};

			iString ws;
			this->GetShell()->GetControlModule()->PackCommand(ws,iViewModule::KeySize(),iv,2);
			this->GetShell()->GetControlModule()->Execute(ws,true,iggWidgetKeyHandlerBase::GetGlobalExecuteFlags());
		}

		virtual void OnVoid3Body()
		{
			static int iv[2] = { 1024, 1024};

			iString ws;
			this->GetShell()->GetControlModule()->PackCommand(ws,iViewModule::KeySize(),iv,2);
			this->GetShell()->GetControlModule()->Execute(ws,true,iggWidgetKeyHandlerBase::GetGlobalExecuteFlags());
		}

		ibgWidgetButtonSubject *mSubject1, *mSubject2, *mSubject3;
	};


	class MethodBox : public iggWidgetKeyRadioBox
	{

	public:

		MethodBox(iggFrame *parent) : iggWidgetKeyRadioBox(1,"Method",0,iVolumeViewSubject::KeyMethod(),parent)
		{
			this->InsertItem("Ray casting");
			this->InsertItem("2D textures");
			this->InsertItem("3D textures");
			this->InsertItem("VolumePro board");
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			iVolumeViewSubject *vo = this->GetShell()->GetControlModule()->GetViewModule()->GetVolumeViewSubject();
			this->SetItem("3D textures",2,vo->Has3DTexture());
			this->SetItem("VolumePro board",3,vo->HasVolumePro());

			this->iggWidgetKeyRadioBox::UpdateWidgetBody();
		}
	};
};


using namespace iggPageVolume_Private;


iggPageVolume::iggPageVolume(iggFrameBase *parent) : iggPageObject(parent,iParameter::_ObjectTypeVolume)
{
	const iImage *icon = iImageFactory::FindIcon("volv.png");

	//
	//  Main page
	// ************************************************
	//
	iggFrame *page0 = new iggFrame(mBook,3);
	mBook->AddPage("Main",icon,page0);
	//
	//  Show
	//
	iggWidget *show = new iggWidgetShowButton(iVolumeViewSubject::Type(),page0);
	page0->AddLine(show);
	page0->AddSpace(2);
	//
	//  Field & method
	//
	iggFrameDataVariableList *pl = new iggFrameDataVariableList(mProvider,"Field",iVolumeViewSubject::KeyVar(),0,page0,0);
	pl->Complete();
	pl->AddDependent(show);
	page0->AddLine(pl);
	page0->AddSpace(10);
	//
	//  Method
	//
	MethodBox *rm = new MethodBox(page0);
	if(this->GetShell()->GetControlModule()->GetViewModule()->GetVolumeViewSubject()->HasVolumePro())
	{
		page0->AddLine(rm,new iggPageVolume_Private::WindowSizeFrame(page0));
	}
	else
	{
		page0->AddLine(rm);
	}
	page0->AddSpace(10);

	page0->SetColStretch(2,10);

	//
	//  Paint page
	// ************************************************
	//
	iggFrame *page1 = new iggFrame(mBook,1);
	mBook->AddPage("Paint",icon,page1);
	//
	//  Book
	//
	iggFrameBook *pb = new iggFrameBook(page1);
	page1->AddLine(pb);
	//
	//  Palette page
	//
	iggFrame *pbpage0 = new iggFrame(pb,2);
	pb->AddPage("Palette",icon,pbpage0);

	iggFramePaletteSelection *ps = new iggFramePaletteSelection(false,iVolumeViewSubject::KeyPalette(),pbpage0,0);
	pbpage0->AddLine(ps);
	pbpage0->AddSpace(20);

	pbpage0->SetColStretch(0,10);
	pbpage0->SetColStretch(1,3);

	//
	//  Material page
	//
	iggFrame *pbpage1 = new iggFrame(pb,2);
	pb->AddPage("Material",icon,pbpage1);

	iggFrameMaterialProperties *mp = new iggFrameMaterialProperties(true,false,iVolumeViewSubject::Type(),pbpage1);
	pbpage1->AddLine(mp);

	pbpage1->AddSpace(10);
	pbpage1->SetColStretch(0,10);
	pbpage1->SetColStretch(1,3);

	//
	//  Opacity page
	// ************************************************
	//
	iggFrame *page2 = new iggFrame(mBook,1);
	mBook->AddPage("Opacity",icon,page2);
	//
	//  FunctionMapping widget
	//
	page2->AddLine(new iggFrameFunctionMapping(iVolumeViewSubject::KeyOpacityFunction(),page2));

	//
	//  Replicate page
	// ************************************************
	//
	iggFrame *page3 = new iggFrame(mBook,2);
	mBook->AddPage("Replicate",icon,page3);
	//
	//  Replicate
	//
	page3->AddLine(new iggFrameReplicate(iVolumeViewSubject::Type(),page3));
	page3->AddSpace(10);
	page3->SetColStretch(1,3);

	//
	//  Extras page
	// ************************************************
	//
	iggFrame *page4 = new iggFrame(mBook,3);
	mBook->AddPage("Extras",icon,page4);
	//
	//  Ray casting settings
	//
	iggFrame *rc = new iggFrame("Ray casting settings",page4,2);
	iggWidgetKeyRadioBox *cm = new iggWidgetKeyRadioBox(1,"Composite method",0,iVolumeViewSubject::KeyCompositeMethod(),rc);
	cm->InsertItem("Interpolate first");
	cm->InsertItem("Classify first");
	iggWidgetKeyRadioBox *it = new iggWidgetKeyRadioBox(1,"Interpolation type",0,iVolumeViewSubject::KeyInterpolationType(),rc);
	it->InsertItem("Nearest neighbor");
	it->InsertItem("Linear");
	iggWidgetKeyRadioBox *bm = new iggWidgetKeyRadioBox(1,"Blend mode",0,iVolumeViewSubject::KeyBlendMode(),rc);
	bm->InsertItem("Composite");
	bm->InsertItem("Maximum intensity");
	rc->AddLine(cm,it);
	rc->AddLine(bm);
	page4->AddLine(rc);
	page4->AddSpace(10);

	iggFrame *rs = new iggFrame("Resample settings",page4,1);
	iggWidgetKeyFloatSlider *fs = new iggWidgetKeyFloatSlider(0.1f,10.0,20,1,4,"Resample in XY",iVolumeViewSubject::KeyXYResample(),_RenderModeUseGlobal,rs);
	fs->SetStretch(3,10);
	rs->AddLine(fs);
	fs = new iggWidgetKeyFloatSlider(0.1f,10.0f,20,1,4,"Resample in Z ",iVolumeViewSubject::KeyZResample(),_RenderModeUseGlobal,rs);
	fs->SetStretch(3,10);
	rs->AddLine(fs);

	page4->AddLine(rs,2);
	page4->AddSpace(10);

	page4->SetColStretch(1,10);
	page4->SetColStretch(2,3);
}

