/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggframereplicate.h"


#include "ierror.h"
#include "iviewsubject.h"

#include "iggwidgetarea.h"
#include "iggwidgetkeyselectionbox.h"


iggFrameReplicate::iggFrameReplicate(const iObjectType &type, iggFrame *parent) : iggFrame("Periodic extensions",parent,3)
{
	const iObjectKey *key;
	iggWidgetKeySpinBox *box1, *box2;

	key = iObjectKeyRegistry::FindKey(iViewSubject::KeyNumReplicas().RetypedKey(type)); IERROR_ASSERT(key);

	this->AddLine((iggWidget *)0,new iggWidgetTextArea("  Replicate down  ",this),new iggWidgetTextArea("   Replicate up   ",this));

	box1 = new iggWidgetKeySpinBox(0,2,0,0,*key,this,0);
	box2 = new iggWidgetKeySpinBox(0,2,0,0,*key,this,1);
	this->AddLine(new iggWidgetTextArea("%b%+X",this),box1,box2);

	box1 = new iggWidgetKeySpinBox(0,2,0,0,*key,this,2);
	box2 = new iggWidgetKeySpinBox(0,2,0,0,*key,this,3);
	this->AddLine(new iggWidgetTextArea("%b%+Y",this),box1,box2);

	box1 = new iggWidgetKeySpinBox(0,2,0,0,*key,this,4);
	box2 = new iggWidgetKeySpinBox(0,2,0,0,*key,this,5);
	this->AddLine(new iggWidgetTextArea("%b%+Z",this),box1,box2);

	this->SetColStretch(0,101);
	this->SetColStretch(1,100);
}

