/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ilookuptable.h"


#include "ierror.h"
#include "ipalette.h"


#include <vtkMath.h>


//
//  Optimized vtkLookupTable
//
iLookupTable* iLookupTable::New()
{
	return new iLookupTable;
}


iLookupTable::iLookupTable()
{
	mPalette = 0;
	mIsReversed = false;
}


void iLookupTable::SetPalette(const iPalette *p)
{
	if(p != mPalette)
	{
		mPalette = p;
		this->Modified();
		this->Build();
	}
}


void iLookupTable::SetReversed(bool s)
{
	if(s != mIsReversed)
	{
		mIsReversed = s;
		this->Modified();
		this->Build();
	}
}


void iLookupTable::SetColor(const iColor &c)
{
	double *rgb = c.ToVTK();
	double hsv[3];
	vtkMath::RGBToHSV(rgb,hsv);
	this->SetHueRange(hsv[0],hsv[0]);
	this->SetSaturationRange(hsv[1],hsv[1]);
	this->SetValueRange(0.0,1.0);
	this->Modified();
	this->Build();
}


void iLookupTable::OnStretchChanged()
{
	switch(mStretch)
	{
	case iParameter::_StretchLog:
		{
			this->SetScaleToLog10();
			break;
		}
	case iParameter::_StretchLin:
		{
			this->SetScaleToLinear();
			break;
		}
	default:
		{
			this->SetScaleToLinear();
			IERROR_REPORT("This stretch is not implemented.");
		}
	}
	this->Modified();
}


void iLookupTable::ForceBuild()
{
	if(mPalette != 0)
	{
		this->Table->SetArray(mPalette->GetLookupTable(mIsReversed)->GetPointer(0),4*mPalette->GetLookupTable(mIsReversed)->GetNumberOfColors(),1);
		this->BuildTime.Modified();
	}
	else
	{
		this->Table->Initialize();
		vtkLookupTable::ForceBuild();
	}
}

