/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  IFrIT animator script class - maps animator commands to function calls
//

#ifndef IANIMATORSCRIPT_H
#define IANIMATORSCRIPT_H


#include "ibasescript.h"


class iAnimator;
class iControlScript;
class iDataType;


class iAnimatorScript: public iBaseScript 
{

	friend class iAnimator;
	friend class iExtensionFactory;

public:

	static iAnimatorScript* New(iAnimator *);

	inline iAnimator* GetAnimator() const { return mAnimator; }

	void SetInRender(bool s) { mInRender = s; }
	inline bool IsInRender() const { return mInRender; }

protected:

	iAnimatorScript(iAnimator *m);
	virtual ~iAnimatorScript();

	//
	//  Access to line-by-line driver
	//
	void Start();
	void Finish();
	bool Continue();

	//
	//  helper functions
	//
	static void LoadFileByType(iScript *me, iValue* v, int key, const iDataType &type);

	iControlScript *mEmbeddedControlScript;
	//
	//  Temporary iValues
	//
	static iValue *valIS, *valRS, *valRP, *valVA3;

	//
	//  Render functions
	//
	static void Render(iScript *me, iValue* v, iValue::Assignment rel);
	static void RenderAll(iScript *me, iValue* v, iValue::Assignment rel);
	static void MultiRender(iScript *me, iValue* v, iValue::Assignment rel);

	//
	//  basic functions
	//
	static void Reset(iScript *me);
	static void Load(iScript *me, iValue* v, iValue::Assignment rel);
	static void Style(iScript *me, iValue* v, iValue::Assignment rel);
	static void FramesPerFile(iScript *me, iValue* v, iValue::Assignment rel);
	static void NumBlendedFrames(iScript *me, iValue* v, iValue::Assignment rel);
	static void NumTransitionFrames(iScript *me, iValue* v, iValue::Assignment rel);
	static void FlybySpeed(iScript *me, iValue* v, iValue::Assignment rel);
	static void RotationPhi(iScript *me, iValue* v, iValue::Assignment rel);
	static void RotationTheta(iScript *me, iValue* v, iValue::Assignment rel);
	static void RotationRoll(iScript *me, iValue* v1, iValue::Assignment rel);
	static void Scale(iScript *me, iValue* v, iValue::Assignment rel);
	static void CrossSectionSpeed(iScript *me, iValue* v, iValue::Assignment rel);
	static void ScalarFieldLowerLimit(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void ScalarFieldUpperLimit(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void ParticleSetLowerLimit(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void ParticleSetUpperLimit(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void VectorFieldUpperLimit(iScript *me, iValue* v, iValue::Assignment rel);
	static void TensorFieldUpperLimit(iScript *me, iValue* v, iValue::Assignment rel);
	static void CameraFocus(iScript *me, iValue* v, iValue::Assignment rel);
	static void CameraPosition(iScript *me, iValue* v, iValue::Assignment rel);
	static void CameraViewUp(iScript *me, iValue* v, iValue::Assignment rel);
	static void CameraScale(iScript *me, iValue* v, iValue::Assignment rel);
	static void Projection(iScript *me, iValue* v, iValue::Assignment rel);
	static void StopOnPath(iScript *me, iValue* v, iValue::Assignment rel);
	static void TimeLabel(iScript *me, iValue* v, iValue::Assignment rel);
	static void TimeLabelValue(iScript *me, iValue* v, iValue::Assignment rel);
	static void ColorBars(iScript *me, iValue* v, iValue::Assignment rel);
	static void BoundingBox(iScript *me, iValue* v, iValue::Assignment rel);

	static void ExecuteControlScript(iScript *me, iValue* v, iValue::Assignment rel);
	static void EmbedControlScript(iScript *me, iValue* v, iValue::Assignment rel);

	//
	//  Title page and logo
	//
	static void TitlePageFile(iScript *me, iValue* v, iValue::Assignment rel);
	static void TitlePageNumFrames(iScript *me, iValue* v, iValue::Assignment rel);
	static void TitlePageNumBlendedFrames(iScript *me, iValue* v, iValue::Assignment rel);
	static void LogoFile(iScript *me, iValue* v, iValue::Assignment rel);
	static void LogoOpacity(iScript *me, iValue* v, iValue::Assignment rel);
	static void LogoPosition(iScript *me, iValue* v, iValue::Assignment rel);

	//
	//  iViewSubject manipulation
	//
	static void SurfaceVar(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void SurfaceLevel(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void SurfaceOpacity(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);

	static void CrossSectionVar(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void CrossSectionDir(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void CrossSectionPos(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);

	static void VolumeVar(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);

	static void ParticlesOpacity(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void ParticlesDownsampleFactor(iScript *me, iValue *v0, iValue::Assignment rel);

	static void MarkerPosition(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void MarkerSize(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);
	static void MarkerOpacity(iScript *me, iValue* n, iValue* v, iValue::Assignment rel);

	//
	//  Global variable functions
	//
	static iValue* GetMarkerPosition(iScript *me, int i);

	//
	//  File loading functions - for batch operations
	//
	static void LoadUniformScalarsFile(iScript *me, iValue* v, iValue::Assignment rel);
	static void LoadBasicParticlesFile(iScript *me, iValue* v, iValue::Assignment rel);
	static void LoadUniformVectorsFile(iScript *me, iValue* v, iValue::Assignment rel);
	static void LoadUniformTensorsFile(iScript *me, iValue* v, iValue::Assignment rel);

	//
	//  Object showing/hiding functions - for batch operations
	//
	static void ShowSurface(iScript *me, iValue* v, iValue::Assignment rel);
	static void ShowCrossSection(iScript *me, iValue* v, iValue::Assignment rel);
	static void ShowVolume(iScript *me, iValue* v, iValue::Assignment rel);
	static void ShowParticles(iScript *me, iValue* v, iValue::Assignment rel);
	static void ShowVectorField(iScript *me, iValue* v, iValue::Assignment rel);
	static void ShowTensorField(iScript *me, iValue* v, iValue::Assignment rel);

	bool mInRender;
	iAnimator *mAnimator;
};

#endif // IANIMATORSCRIPT_H
