/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggframepaletteselectionbase.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "ipalette.h"
#include "ishell.h"

#include "iggdialogpaletteeditor.h"
#include "iggmainwindow.h"
#include "iggwidgetarea.h"
#include "iggwidgetotherbutton.h"

#include "ibgwidgetselectionboxsubject.h"

#include "iggsubjectfactory.h"

//
//  Templates
//
#include "iarraytemplate.h"


namespace iggFramePaletteSelectionBase_Private
{
	class PaletteView : public iggWidgetImageArea
	{

	public:

		PaletteView(iggFramePaletteSelectionBase *parent) : iggWidgetImageArea(parent)
		{
			mFrame = parent;
		}

	protected:

		virtual bool UpdateWidgetBody()
		{
			if(mFrame->GetCurrentPalette() != 0)
			{
				this->SetImage(*mFrame->GetCurrentPalette()->GetImage(),true);
				return iggWidgetImageArea::UpdateWidgetBody();
			}
			else return false;
		}

		iggFramePaletteSelectionBase *mFrame;
	};


	class PaletteList : public iggWidget
	{

	public:

		PaletteList(iggFramePaletteSelectionBase *parent) : iggWidget(parent)
		{
			mSubject = iggSubjectFactory::CreateWidgetComboBoxSubject(this,"Palette");
			mFrame = parent;

			this->SetBaloonHelp("Choose palette from the list","Choose a palette from the list of all available palettes. Use Palette Editor from the dialog menus to create new or change existing palettes.");
		}

		virtual ~PaletteList()
		{
		}

		int GetValue() const
		{
			return mSubject->GetValue();
		}

	protected:

		virtual bool UpdateWidgetBody()
		{
			int i, np = this->GetShell()->GetControlModule()->GetNumberOfPalettes();

			mSubject->Clear();
			for(i=0; i<np; i++)
			{
				mSubject->InsertItem(this->GetShell()->GetControlModule()->GetPalette(i)->GetName());
			}

			mSubject->SetValue(mFrame->GetCurrentPaletteIndex());
			return true;
		}

		virtual void OnInt1Body(int n)
		{
			mFrame->SetCurrentPaletteIndex(n);
		}

		iggFramePaletteSelectionBase *mFrame;
		ibgWidgetComboBoxSubject *mSubject;
	};


	class LaunchButton : public iggWidgetLaunchButton
	{

	public:

		LaunchButton(PaletteList *list, iggFrame *parent) : iggWidgetLaunchButton(parent->GetMainWindow()->GetDialogPaletteEditor(),"Launch palette editor",parent)
		{
			mList = list;
		}

	protected:

		virtual void OnVoid1Body()
		{
			if(mDialog!=0 && mList!=0)
			{
				iPointerCast<iggDialogPaletteEditor,iggDialog>(mDialog)->SetCurrentPaletteIndex(mList->GetValue());
			}
			iggWidgetLaunchButton::OnVoid1Body();
		}

		PaletteList *mList;
	};
};


using namespace iggFramePaletteSelectionBase_Private;


iggFramePaletteSelectionBase::iggFramePaletteSelectionBase(bool witheditor, iggFrame *parent) : iggFrame("Current palette",parent,2)
{
	mCurrentPaletteIndex = 0;

	PaletteView *view = new PaletteView(this);
	PaletteList *list = new PaletteList(this);
	this->AddLine(view,2);
	this->AddLine(list,2);

	if(witheditor)
	{
		this->AddLine(new LaunchButton(list,this));
	}

	this->SetColStretch(1,10);

	list->AddDependent(view);
	List().AddUnique(this);
}


iggFramePaletteSelectionBase::~iggFramePaletteSelectionBase()
{
	List().Remove(this);
}


void iggFramePaletteSelectionBase::SetCurrentPaletteIndex(int n)
{
	if(n>=0 && n<this->GetShell()->GetControlModule()->GetNumberOfPalettes())
	{
		mCurrentPaletteIndex = n;
		this->SetCurrentPaletteIndexBody(n);
	}
	else IERROR_REPORT_ERROR("Incorrect palette number.");
}


void iggFramePaletteSelectionBase::UpdateAll()
{
	iPointerArray<iggFramePaletteSelectionBase> &list = List();
	int i, n = list.Size();

	for(i=0; i<n; i++) list[i]->UpdateWidget();
}


iPointerArray<iggFramePaletteSelectionBase>& iggFramePaletteSelectionBase::List()
{
	static iPointerArray<iggFramePaletteSelectionBase> list;
	return list;
}

