/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggframepaletteselection.h"


#include "icontrolmodule.h"
#include "ipalette.h"
#include "ishell.h"

#include "iggwidgetkeyhandler.h"

#include "iggparameter.h"
using namespace iggParameter;

//
//  templates
//
#include "iggwidgetkeyhandlertemplate.h"


iggFramePaletteSelection::iggFramePaletteSelection(const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : iggFramePaletteSelectionBase(true,parent)
{
	//
	//  This class combines the functionality of iggWidgetKeyHandler and iggFramePaletteSelectionBase.
	//  Since we cannot inherit both of them (that would create two instances of toolkit-dependent
	//  classes, we create a dummy invisible KeyHandler and use its functionality.
	//
	mDummy = new iggWidgetKeyDummy<int>(key,this,index,indkey);
}


iggFramePaletteSelection::~iggFramePaletteSelection()
{
}


void iggFramePaletteSelection::SetIndex(int i)
{
	mDummy->SetIndex(i);
	mDummy->UpdateWidget();
	this->SetCurrentPaletteIndex(mDummy->GetValue());
	this->UpdateWidget();
}


void iggFramePaletteSelection::SetCurrentPaletteIndexBody(int i)
{
	mDummy->PushValue(i);
}


iPalette* iggFramePaletteSelection::GetCurrentPalette() const
{
	return this->GetShell()->GetControlModule()->GetPalette(mCurrentPaletteIndex);
}

